/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.deployedDevices.FleetCreator;
import com.twilio.rest.preview.deployedDevices.FleetDeleter;
import com.twilio.rest.preview.deployedDevices.FleetFetcher;
import com.twilio.rest.preview.deployedDevices.FleetReader;
import com.twilio.rest.preview.deployedDevices.FleetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fleet
extends Resource {
    private static final long serialVersionUID = 162068485825595L;
    private final String sid;
    private final URI url;
    private final String uniqueName;
    private final String friendlyName;
    private final String accountSid;
    private final String defaultDeploymentSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Map<String, String> links;

    public static FleetCreator creator() {
        return new FleetCreator();
    }

    public static FleetDeleter deleter(String pathSid) {
        return new FleetDeleter(pathSid);
    }

    public static FleetFetcher fetcher(String pathSid) {
        return new FleetFetcher(pathSid);
    }

    public static FleetReader reader() {
        return new FleetReader();
    }

    public static FleetUpdater updater(String pathSid) {
        return new FleetUpdater(pathSid);
    }

    public static Fleet fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Fleet fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Fleet(@JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="default_deployment_sid") String defaultDeploymentSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.url = url;
        this.uniqueName = uniqueName;
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.defaultDeploymentSid = defaultDeploymentSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDefaultDeploymentSid() {
        return this.defaultDeploymentSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fleet other = (Fleet)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.defaultDeploymentSid, other.defaultDeploymentSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.url, this.uniqueName, this.friendlyName, this.accountSid, this.defaultDeploymentSid, this.dateCreated, this.dateUpdated, this.links);
    }

    public String toString() {
        return "Fleet(sid=" + this.getSid() + ", url=" + this.getUrl() + ", uniqueName=" + this.getUniqueName() + ", friendlyName=" + this.getFriendlyName() + ", accountSid=" + this.getAccountSid() + ", defaultDeploymentSid=" + this.getDefaultDeploymentSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", links=" + this.getLinks() + ")";
    }
}

