/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.oauth.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.oauth.v1.Token;

public class TokenCreator
extends Creator<Token> {
    private String grantType;
    private String clientId;
    private String clientSecret;
    private String code;
    private String redirectUri;
    private String audience;
    private String refreshToken;
    private String scope;

    public TokenCreator(String grantType, String clientId) {
        this.grantType = grantType;
        this.clientId = clientId;
    }

    public TokenCreator setGrantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    public TokenCreator setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public TokenCreator setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public TokenCreator setCode(String code) {
        this.code = code;
        return this;
    }

    public TokenCreator setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public TokenCreator setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public TokenCreator setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public TokenCreator setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public Token create(TwilioRestClient client) {
        String path = "/v1/token";
        path = path.replace("{GrantType}", this.grantType.toString());
        path = path.replace("{ClientId}", this.clientId.toString());
        Request request = new Request(HttpMethod.POST, Domains.OAUTH.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Token creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Token.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.grantType != null) {
            request.addPostParam("GrantType", this.grantType);
        }
        if (this.clientId != null) {
            request.addPostParam("ClientId", this.clientId);
        }
        if (this.clientSecret != null) {
            request.addPostParam("ClientSecret", this.clientSecret);
        }
        if (this.code != null) {
            request.addPostParam("Code", this.code);
        }
        if (this.redirectUri != null) {
            request.addPostParam("RedirectUri", this.redirectUri);
        }
        if (this.audience != null) {
            request.addPostParam("Audience", this.audience);
        }
        if (this.refreshToken != null) {
            request.addPostParam("RefreshToken", this.refreshToken);
        }
        if (this.scope != null) {
            request.addPostParam("Scope", this.scope);
        }
    }
}

