/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.oauth.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.oauth.v1.AuthorizeFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Authorize
extends Resource {
    private static final long serialVersionUID = 245900587626041L;
    private final URI redirectTo;

    public static AuthorizeFetcher fetcher() {
        return new AuthorizeFetcher();
    }

    public static Authorize fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Authorize.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Authorize fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Authorize.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Authorize(@JsonProperty(value="redirect_to") URI redirectTo) {
        this.redirectTo = redirectTo;
    }

    public final URI getRedirectTo() {
        return this.redirectTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorize other = (Authorize)o;
        return Objects.equals(this.redirectTo, other.redirectTo);
    }

    public int hashCode() {
        return Objects.hash(this.redirectTo);
    }

    public String toString() {
        return "Authorize(redirectTo=" + this.getRedirectTo() + ")";
    }
}

