/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentCreator;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentDeleter;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentReader;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SupportingDocument
extends Resource {
    private static final long serialVersionUID = 24162340566274L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String mimeType;
    private final Status status;
    private final String failureReason;
    private final String type;
    private final Map<String, Object> attributes;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static SupportingDocumentCreator creator(String friendlyName, String type) {
        return new SupportingDocumentCreator(friendlyName, type);
    }

    public static SupportingDocumentDeleter deleter(String pathSid) {
        return new SupportingDocumentDeleter(pathSid);
    }

    public static SupportingDocumentFetcher fetcher(String pathSid) {
        return new SupportingDocumentFetcher(pathSid);
    }

    public static SupportingDocumentReader reader() {
        return new SupportingDocumentReader();
    }

    public static SupportingDocumentUpdater updater(String pathSid) {
        return new SupportingDocumentUpdater(pathSid);
    }

    public static SupportingDocument fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SupportingDocument.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SupportingDocument fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SupportingDocument.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SupportingDocument(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="mime_type") String mimeType, @JsonProperty(value="status") Status status, @JsonProperty(value="failure_reason") String failureReason, @JsonProperty(value="type") String type, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.mimeType = mimeType;
        this.status = status;
        this.failureReason = failureReason;
        this.type = type;
        this.attributes = attributes;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getFailureReason() {
        return this.failureReason;
    }

    public final String getType() {
        return this.type;
    }

    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportingDocument other = (SupportingDocument)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.type, other.type) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.mimeType, this.status, this.failureReason, this.type, this.attributes, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "SupportingDocument(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", mimeType=" + this.getMimeType() + ", status=" + (Object)((Object)this.getStatus()) + ", failureReason=" + this.getFailureReason() + ", type=" + this.getType() + ", attributes=" + this.getAttributes() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PENDING_REVIEW("pending-review"),
        REJECTED("rejected"),
        APPROVED("approved"),
        EXPIRED("expired"),
        PROVISIONALLY_APPROVED("provisionally-approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

