/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Regulation;

public class RegulationReader
extends Reader<Regulation> {
    private Regulation.EndUserType endUserType;
    private String isoCountry;
    private String numberType;
    private Integer pageSize;

    public RegulationReader setEndUserType(Regulation.EndUserType endUserType) {
        this.endUserType = endUserType;
        return this;
    }

    public RegulationReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public RegulationReader setNumberType(String numberType) {
        this.numberType = numberType;
        return this;
    }

    public RegulationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Regulation> read(TwilioRestClient client) {
        return new ResourceSet<Regulation>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Regulation> firstPage(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Regulations";
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Regulation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Regulation read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), Regulation.class, client.getObjectMapper());
    }

    @Override
    public Page<Regulation> previousPage(Page<Regulation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Regulation> nextPage(Page<Regulation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Regulation> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.endUserType != null) {
            request.addQueryParam("EndUserType", this.endUserType.toString());
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.numberType != null) {
            request.addQueryParam("NumberType", this.numberType);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

