/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.EndUser;
import java.util.Map;

public class EndUserCreator
extends Creator<EndUser> {
    private String friendlyName;
    private EndUser.Type type;
    private Map<String, Object> attributes;

    public EndUserCreator(String friendlyName, EndUser.Type type) {
        this.friendlyName = friendlyName;
        this.type = type;
    }

    public EndUserCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public EndUserCreator setType(EndUser.Type type) {
        this.type = type;
        return this;
    }

    public EndUserCreator setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public EndUser create(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/EndUsers";
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{Type}", this.type.toString());
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EndUser creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return EndUser.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", Converter.mapToJson(this.attributes));
        }
    }
}

