/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.BulkHostedNumberOrderCreator;
import com.twilio.rest.numbers.v2.BulkHostedNumberOrderFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkHostedNumberOrder
extends Resource {
    private static final long serialVersionUID = 251635704058877L;
    private final String bulkHostingSid;
    private final RequestStatus requestStatus;
    private final String friendlyName;
    private final String notificationEmail;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateCompleted;
    private final URI url;
    private final Integer totalCount;
    private final List<Map<String, Object>> results;

    public static BulkHostedNumberOrderCreator creator() {
        return new BulkHostedNumberOrderCreator();
    }

    public static BulkHostedNumberOrderFetcher fetcher(String pathBulkHostingSid) {
        return new BulkHostedNumberOrderFetcher(pathBulkHostingSid);
    }

    public static BulkHostedNumberOrder fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BulkHostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BulkHostedNumberOrder fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BulkHostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BulkHostedNumberOrder(@JsonProperty(value="bulk_hosting_sid") String bulkHostingSid, @JsonProperty(value="request_status") RequestStatus requestStatus, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="notification_email") String notificationEmail, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_completed") String dateCompleted, @JsonProperty(value="url") URI url, @JsonProperty(value="total_count") Integer totalCount, @JsonProperty(value="results") List<Map<String, Object>> results) {
        this.bulkHostingSid = bulkHostingSid;
        this.requestStatus = requestStatus;
        this.friendlyName = friendlyName;
        this.notificationEmail = notificationEmail;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateCompleted = DateConverter.iso8601DateTimeFromString(dateCompleted);
        this.url = url;
        this.totalCount = totalCount;
        this.results = results;
    }

    public final String getBulkHostingSid() {
        return this.bulkHostingSid;
    }

    public final RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getNotificationEmail() {
        return this.notificationEmail;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Integer getTotalCount() {
        return this.totalCount;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkHostedNumberOrder other = (BulkHostedNumberOrder)o;
        return Objects.equals(this.bulkHostingSid, other.bulkHostingSid) && Objects.equals((Object)this.requestStatus, (Object)other.requestStatus) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.notificationEmail, other.notificationEmail) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateCompleted, other.dateCompleted) && Objects.equals(this.url, other.url) && Objects.equals(this.totalCount, other.totalCount) && Objects.equals(this.results, other.results);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bulkHostingSid, this.requestStatus, this.friendlyName, this.notificationEmail, this.dateCreated, this.dateCompleted, this.url, this.totalCount, this.results});
    }

    public String toString() {
        return "BulkHostedNumberOrder(bulkHostingSid=" + this.getBulkHostingSid() + ", requestStatus=" + (Object)((Object)this.getRequestStatus()) + ", friendlyName=" + this.getFriendlyName() + ", notificationEmail=" + this.getNotificationEmail() + ", dateCreated=" + this.getDateCreated() + ", dateCompleted=" + this.getDateCompleted() + ", url=" + this.getUrl() + ", totalCount=" + this.getTotalCount() + ", results=" + this.getResults() + ")";
    }

    public static enum RequestStatus {
        QUEUED("QUEUED"),
        IN_PROGRESS("IN_PROGRESS"),
        PROCESSED("PROCESSED");

        private final String value;

        private RequestStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RequestStatus forValue(String value) {
            return (RequestStatus)Promoter.enumFromString((String)value, (Enum[])RequestStatus.values());
        }
    }
}

