/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.AuthorizationDocument;
import com.twilio.type.PhoneNumber;
import java.util.List;

public class AuthorizationDocumentCreator
extends Creator<AuthorizationDocument> {
    private String addressSid;
    private String email;
    private PhoneNumber contactPhoneNumber;
    private List<String> hostedNumberOrderSids;
    private String contactTitle;
    private List<String> ccEmails;

    public AuthorizationDocumentCreator(String addressSid, String email, PhoneNumber contactPhoneNumber, List<String> hostedNumberOrderSids) {
        this.addressSid = addressSid;
        this.email = email;
        this.contactPhoneNumber = contactPhoneNumber;
        this.hostedNumberOrderSids = hostedNumberOrderSids;
    }

    public AuthorizationDocumentCreator setAddressSid(String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    public AuthorizationDocumentCreator setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthorizationDocumentCreator setContactPhoneNumber(PhoneNumber contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
        return this;
    }

    public AuthorizationDocumentCreator setContactPhoneNumber(String contactPhoneNumber) {
        return this.setContactPhoneNumber(Promoter.phoneNumberFromString(contactPhoneNumber));
    }

    public AuthorizationDocumentCreator setHostedNumberOrderSids(List<String> hostedNumberOrderSids) {
        this.hostedNumberOrderSids = hostedNumberOrderSids;
        return this;
    }

    public AuthorizationDocumentCreator setHostedNumberOrderSids(String hostedNumberOrderSids) {
        return this.setHostedNumberOrderSids(Promoter.listOfOne(hostedNumberOrderSids));
    }

    public AuthorizationDocumentCreator setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
        return this;
    }

    public AuthorizationDocumentCreator setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public AuthorizationDocumentCreator setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    @Override
    public AuthorizationDocument create(TwilioRestClient client) {
        String path = "/v2/HostedNumber/AuthorizationDocuments";
        path = path.replace("{AddressSid}", this.addressSid.toString());
        path = path.replace("{Email}", this.email.toString());
        path = path.replace("{ContactPhoneNumber}", this.contactPhoneNumber.encode("utf-8"));
        path = path.replace("{HostedNumberOrderSids}", this.hostedNumberOrderSids.toString());
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AuthorizationDocument.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.contactPhoneNumber != null) {
            request.addPostParam("ContactPhoneNumber", this.contactPhoneNumber.toString());
        }
        if (this.hostedNumberOrderSids != null) {
            for (String prop : this.hostedNumberOrderSids) {
                request.addPostParam("HostedNumberOrderSids", prop);
            }
        }
        if (this.contactTitle != null) {
            request.addPostParam("ContactTitle", this.contactTitle);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
    }
}

