/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.PortingPortInFetch;

public class PortingPortInFetchFetcher
extends Fetcher<PortingPortInFetch> {
    private String pathPortInRequestSid;

    public PortingPortInFetchFetcher(String pathPortInRequestSid) {
        this.pathPortInRequestSid = pathPortInRequestSid;
    }

    @Override
    public PortingPortInFetch fetch(TwilioRestClient client) {
        String path = "/v1/Porting/PortIn/{PortInRequestSid}";
        path = path.replace("{PortInRequestSid}", this.pathPortInRequestSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PortingPortInFetch fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PortingPortInFetch.fromJson(response.getStream(), client.getObjectMapper());
    }
}

