/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.PortingBulkPortability;
import java.util.List;

public class PortingBulkPortabilityCreator
extends Creator<PortingBulkPortability> {
    private List<String> phoneNumbers;

    public PortingBulkPortabilityCreator(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public PortingBulkPortabilityCreator setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public PortingBulkPortabilityCreator setPhoneNumbers(String phoneNumbers) {
        return this.setPhoneNumbers(Promoter.listOfOne(phoneNumbers));
    }

    @Override
    public PortingBulkPortability create(TwilioRestClient client) {
        String path = "/v1/Porting/Portability";
        path = path.replace("{PhoneNumbers}", this.phoneNumbers.toString());
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PortingBulkPortability creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PortingBulkPortability.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumbers != null) {
            for (String prop : this.phoneNumbers) {
                request.addPostParam("PhoneNumbers", prop);
            }
        }
    }
}

