/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingBulkPortabilityCreator;
import com.twilio.rest.numbers.v1.PortingBulkPortabilityFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingBulkPortability
extends Resource {
    private static final long serialVersionUID = 54521824330020L;
    private final String sid;
    private final Status status;
    private final ZonedDateTime datetimeCreated;
    private final List<Map<String, Object>> phoneNumbers;
    private final URI url;

    public static PortingBulkPortabilityCreator creator(List<String> phoneNumbers) {
        return new PortingBulkPortabilityCreator(phoneNumbers);
    }

    public static PortingBulkPortabilityFetcher fetcher(String pathSid) {
        return new PortingBulkPortabilityFetcher(pathSid);
    }

    public static PortingBulkPortability fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingBulkPortability.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingBulkPortability fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingBulkPortability.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingBulkPortability(@JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="datetime_created") String datetimeCreated, @JsonProperty(value="phone_numbers") List<Map<String, Object>> phoneNumbers, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.status = status;
        this.datetimeCreated = DateConverter.iso8601DateTimeFromString(datetimeCreated);
        this.phoneNumbers = phoneNumbers;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getDatetimeCreated() {
        return this.datetimeCreated;
    }

    public final List<Map<String, Object>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingBulkPortability other = (PortingBulkPortability)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.datetimeCreated, other.datetimeCreated) && Objects.equals(this.phoneNumbers, other.phoneNumbers) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.status, this.datetimeCreated, this.phoneNumbers, this.url});
    }

    public String toString() {
        return "PortingBulkPortability(sid=" + this.getSid() + ", status=" + (Object)((Object)this.getStatus()) + ", datetimeCreated=" + this.getDatetimeCreated() + ", phoneNumbers=" + this.getPhoneNumbers() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        EXPIRED("expired");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

