/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.Eligibility;

public class EligibilityCreator
extends Creator<Eligibility> {
    private Object body;

    public EligibilityCreator setBody(Object body) {
        this.body = body;
        return this;
    }

    @Override
    public Eligibility create(TwilioRestClient client) {
        String path = "/v1/HostedNumber/Eligibility";
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.JSON);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Eligibility creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Eligibility.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request, TwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.body != null) {
            request.setBody(Eligibility.toJson(this.body, objectMapper));
        }
    }
}

