/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.device;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.device.DeviceSecret;

public class DeviceSecretDeleter
extends Deleter<DeviceSecret> {
    private String pathDeviceSid;
    private String pathKey;

    public DeviceSecretDeleter(String pathDeviceSid, String pathKey) {
        this.pathDeviceSid = pathDeviceSid;
        this.pathKey = pathKey;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v1/Devices/{DeviceSid}/Secrets/{Key}";
        path = path.replace("{DeviceSid}", this.pathDeviceSid.toString());
        path = path.replace("{Key}", this.pathKey.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.MICROVISOR.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeviceSecret delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

