/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.device;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.microvisor.v1.device.DeviceSecretCreator;
import com.twilio.rest.microvisor.v1.device.DeviceSecretDeleter;
import com.twilio.rest.microvisor.v1.device.DeviceSecretFetcher;
import com.twilio.rest.microvisor.v1.device.DeviceSecretReader;
import com.twilio.rest.microvisor.v1.device.DeviceSecretUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeviceSecret
extends Resource {
    private static final long serialVersionUID = 4318157927104L;
    private final String deviceSid;
    private final String key;
    private final ZonedDateTime dateRotated;
    private final URI url;

    public static DeviceSecretCreator creator(String pathDeviceSid, String key, String value) {
        return new DeviceSecretCreator(pathDeviceSid, key, value);
    }

    public static DeviceSecretDeleter deleter(String pathDeviceSid, String pathKey) {
        return new DeviceSecretDeleter(pathDeviceSid, pathKey);
    }

    public static DeviceSecretFetcher fetcher(String pathDeviceSid, String pathKey) {
        return new DeviceSecretFetcher(pathDeviceSid, pathKey);
    }

    public static DeviceSecretReader reader(String pathDeviceSid) {
        return new DeviceSecretReader(pathDeviceSid);
    }

    public static DeviceSecretUpdater updater(String pathDeviceSid, String pathKey, String value) {
        return new DeviceSecretUpdater(pathDeviceSid, pathKey, value);
    }

    public static DeviceSecret fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DeviceSecret.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DeviceSecret fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DeviceSecret.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DeviceSecret(@JsonProperty(value="device_sid") String deviceSid, @JsonProperty(value="key") String key, @JsonProperty(value="date_rotated") String dateRotated, @JsonProperty(value="url") URI url) {
        this.deviceSid = deviceSid;
        this.key = key;
        this.dateRotated = DateConverter.iso8601DateTimeFromString(dateRotated);
        this.url = url;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getKey() {
        return this.key;
    }

    public final ZonedDateTime getDateRotated() {
        return this.dateRotated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceSecret other = (DeviceSecret)o;
        return Objects.equals(this.deviceSid, other.deviceSid) && Objects.equals(this.key, other.key) && Objects.equals(this.dateRotated, other.dateRotated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.deviceSid, this.key, this.dateRotated, this.url);
    }

    public String toString() {
        return "DeviceSecret(deviceSid=" + this.getDeviceSid() + ", key=" + this.getKey() + ", dateRotated=" + this.getDateRotated() + ", url=" + this.getUrl() + ")";
    }
}

