/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.AccountConfig;

public class AccountConfigFetcher
extends Fetcher<AccountConfig> {
    private String pathKey;

    public AccountConfigFetcher(String pathKey) {
        this.pathKey = pathKey;
    }

    @Override
    public AccountConfig fetch(TwilioRestClient client) {
        String path = "/v1/Configs/{Key}";
        path = path.replace("{Key}", this.pathKey.toString());
        Request request = new Request(HttpMethod.GET, Domains.MICROVISOR.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AccountConfig fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AccountConfig.fromJson(response.getStream(), client.getObjectMapper());
    }
}

