/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.AccountConfig;

public class AccountConfigCreator
extends Creator<AccountConfig> {
    private String key;
    private String value;

    public AccountConfigCreator(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public AccountConfigCreator setKey(String key) {
        this.key = key;
        return this;
    }

    public AccountConfigCreator setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public AccountConfig create(TwilioRestClient client) {
        String path = "/v1/Configs";
        path = path.replace("{Key}", this.key.toString());
        path = path.replace("{Value}", this.value.toString());
        Request request = new Request(HttpMethod.POST, Domains.MICROVISOR.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AccountConfig creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AccountConfig.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.key != null) {
            request.addPostParam("Key", this.key);
        }
        if (this.value != null) {
            request.addPostParam("Value", this.value);
        }
    }
}

