/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.UsAppToPersonUsecase;

public class UsAppToPersonUsecaseFetcher
extends Fetcher<UsAppToPersonUsecase> {
    private String pathMessagingServiceSid;
    private String brandRegistrationSid;

    public UsAppToPersonUsecaseFetcher(String pathMessagingServiceSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
    }

    public UsAppToPersonUsecaseFetcher setBrandRegistrationSid(String brandRegistrationSid) {
        this.brandRegistrationSid = brandRegistrationSid;
        return this;
    }

    @Override
    public UsAppToPersonUsecase fetch(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/Compliance/Usa2p/Usecases";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsAppToPersonUsecase fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UsAppToPersonUsecase.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.brandRegistrationSid != null) {
            request.addQueryParam("BrandRegistrationSid", this.brandRegistrationSid);
        }
    }
}

