/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.UsAppToPerson;
import java.util.List;

public class UsAppToPersonUpdater
extends Updater<UsAppToPerson> {
    private String pathMessagingServiceSid;
    private String pathSid;
    private Boolean hasEmbeddedLinks;
    private Boolean hasEmbeddedPhone;
    private List<String> messageSamples;
    private String messageFlow;
    private String description;
    private Boolean ageGated;
    private Boolean directLending;

    public UsAppToPersonUpdater(String pathMessagingServiceSid, String pathSid, Boolean hasEmbeddedLinks, Boolean hasEmbeddedPhone, List<String> messageSamples, String messageFlow, String description, Boolean ageGated, Boolean directLending) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.pathSid = pathSid;
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        this.hasEmbeddedPhone = hasEmbeddedPhone;
        this.messageSamples = messageSamples;
        this.messageFlow = messageFlow;
        this.description = description;
        this.ageGated = ageGated;
        this.directLending = directLending;
    }

    public UsAppToPersonUpdater setHasEmbeddedLinks(Boolean hasEmbeddedLinks) {
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        return this;
    }

    public UsAppToPersonUpdater setHasEmbeddedPhone(Boolean hasEmbeddedPhone) {
        this.hasEmbeddedPhone = hasEmbeddedPhone;
        return this;
    }

    public UsAppToPersonUpdater setMessageSamples(List<String> messageSamples) {
        this.messageSamples = messageSamples;
        return this;
    }

    public UsAppToPersonUpdater setMessageSamples(String messageSamples) {
        return this.setMessageSamples(Promoter.listOfOne(messageSamples));
    }

    public UsAppToPersonUpdater setMessageFlow(String messageFlow) {
        this.messageFlow = messageFlow;
        return this;
    }

    public UsAppToPersonUpdater setDescription(String description) {
        this.description = description;
        return this;
    }

    public UsAppToPersonUpdater setAgeGated(Boolean ageGated) {
        this.ageGated = ageGated;
        return this;
    }

    public UsAppToPersonUpdater setDirectLending(Boolean directLending) {
        this.directLending = directLending;
        return this;
    }

    @Override
    public UsAppToPerson update(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/Compliance/Usa2p/{Sid}";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{HasEmbeddedLinks}", this.hasEmbeddedLinks.toString());
        path = path.replace("{HasEmbeddedPhone}", this.hasEmbeddedPhone.toString());
        path = path.replace("{MessageSamples}", this.messageSamples.toString());
        path = path.replace("{MessageFlow}", this.messageFlow.toString());
        path = path.replace("{Description}", this.description.toString());
        path = path.replace("{AgeGated}", this.ageGated.toString());
        path = path.replace("{DirectLending}", this.directLending.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsAppToPerson update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UsAppToPerson.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.hasEmbeddedLinks != null) {
            request.addPostParam("HasEmbeddedLinks", this.hasEmbeddedLinks.toString());
        }
        if (this.hasEmbeddedPhone != null) {
            request.addPostParam("HasEmbeddedPhone", this.hasEmbeddedPhone.toString());
        }
        if (this.messageSamples != null) {
            for (String prop : this.messageSamples) {
                request.addPostParam("MessageSamples", prop);
            }
        }
        if (this.messageFlow != null) {
            request.addPostParam("MessageFlow", this.messageFlow);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.ageGated != null) {
            request.addPostParam("AgeGated", this.ageGated.toString());
        }
        if (this.directLending != null) {
            request.addPostParam("DirectLending", this.directLending.toString());
        }
    }
}

