/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.UsAppToPerson;

public class UsAppToPersonReader
extends Reader<UsAppToPerson> {
    private String pathMessagingServiceSid;
    private Integer pageSize;

    public UsAppToPersonReader(String pathMessagingServiceSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
    }

    public UsAppToPersonReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<UsAppToPerson> read(TwilioRestClient client) {
        return new ResourceSet<UsAppToPerson>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UsAppToPerson> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/Compliance/Usa2p";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<UsAppToPerson> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsAppToPerson read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("compliance", response.getContent(), UsAppToPerson.class, client.getObjectMapper());
    }

    @Override
    public Page<UsAppToPerson> previousPage(Page<UsAppToPerson> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsAppToPerson> nextPage(Page<UsAppToPerson> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsAppToPerson> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

