/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.UsAppToPerson;
import java.util.List;

public class UsAppToPersonCreator
extends Creator<UsAppToPerson> {
    private String pathMessagingServiceSid;
    private String brandRegistrationSid;
    private String description;
    private String messageFlow;
    private List<String> messageSamples;
    private String usAppToPersonUsecase;
    private Boolean hasEmbeddedLinks;
    private Boolean hasEmbeddedPhone;
    private String optInMessage;
    private String optOutMessage;
    private String helpMessage;
    private List<String> optInKeywords;
    private List<String> optOutKeywords;
    private List<String> helpKeywords;
    private Boolean subscriberOptIn;
    private Boolean ageGated;
    private Boolean directLending;

    public UsAppToPersonCreator(String pathMessagingServiceSid, String brandRegistrationSid, String description, String messageFlow, List<String> messageSamples, String usAppToPersonUsecase, Boolean hasEmbeddedLinks, Boolean hasEmbeddedPhone) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.brandRegistrationSid = brandRegistrationSid;
        this.description = description;
        this.messageFlow = messageFlow;
        this.messageSamples = messageSamples;
        this.usAppToPersonUsecase = usAppToPersonUsecase;
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        this.hasEmbeddedPhone = hasEmbeddedPhone;
    }

    public UsAppToPersonCreator setBrandRegistrationSid(String brandRegistrationSid) {
        this.brandRegistrationSid = brandRegistrationSid;
        return this;
    }

    public UsAppToPersonCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    public UsAppToPersonCreator setMessageFlow(String messageFlow) {
        this.messageFlow = messageFlow;
        return this;
    }

    public UsAppToPersonCreator setMessageSamples(List<String> messageSamples) {
        this.messageSamples = messageSamples;
        return this;
    }

    public UsAppToPersonCreator setMessageSamples(String messageSamples) {
        return this.setMessageSamples(Promoter.listOfOne(messageSamples));
    }

    public UsAppToPersonCreator setUsAppToPersonUsecase(String usAppToPersonUsecase) {
        this.usAppToPersonUsecase = usAppToPersonUsecase;
        return this;
    }

    public UsAppToPersonCreator setHasEmbeddedLinks(Boolean hasEmbeddedLinks) {
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        return this;
    }

    public UsAppToPersonCreator setHasEmbeddedPhone(Boolean hasEmbeddedPhone) {
        this.hasEmbeddedPhone = hasEmbeddedPhone;
        return this;
    }

    public UsAppToPersonCreator setOptInMessage(String optInMessage) {
        this.optInMessage = optInMessage;
        return this;
    }

    public UsAppToPersonCreator setOptOutMessage(String optOutMessage) {
        this.optOutMessage = optOutMessage;
        return this;
    }

    public UsAppToPersonCreator setHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
        return this;
    }

    public UsAppToPersonCreator setOptInKeywords(List<String> optInKeywords) {
        this.optInKeywords = optInKeywords;
        return this;
    }

    public UsAppToPersonCreator setOptInKeywords(String optInKeywords) {
        return this.setOptInKeywords(Promoter.listOfOne(optInKeywords));
    }

    public UsAppToPersonCreator setOptOutKeywords(List<String> optOutKeywords) {
        this.optOutKeywords = optOutKeywords;
        return this;
    }

    public UsAppToPersonCreator setOptOutKeywords(String optOutKeywords) {
        return this.setOptOutKeywords(Promoter.listOfOne(optOutKeywords));
    }

    public UsAppToPersonCreator setHelpKeywords(List<String> helpKeywords) {
        this.helpKeywords = helpKeywords;
        return this;
    }

    public UsAppToPersonCreator setHelpKeywords(String helpKeywords) {
        return this.setHelpKeywords(Promoter.listOfOne(helpKeywords));
    }

    public UsAppToPersonCreator setSubscriberOptIn(Boolean subscriberOptIn) {
        this.subscriberOptIn = subscriberOptIn;
        return this;
    }

    public UsAppToPersonCreator setAgeGated(Boolean ageGated) {
        this.ageGated = ageGated;
        return this;
    }

    public UsAppToPersonCreator setDirectLending(Boolean directLending) {
        this.directLending = directLending;
        return this;
    }

    @Override
    public UsAppToPerson create(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/Compliance/Usa2p";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        path = path.replace("{BrandRegistrationSid}", this.brandRegistrationSid.toString());
        path = path.replace("{Description}", this.description.toString());
        path = path.replace("{MessageFlow}", this.messageFlow.toString());
        path = path.replace("{MessageSamples}", this.messageSamples.toString());
        path = path.replace("{UsAppToPersonUsecase}", this.usAppToPersonUsecase.toString());
        path = path.replace("{HasEmbeddedLinks}", this.hasEmbeddedLinks.toString());
        path = path.replace("{HasEmbeddedPhone}", this.hasEmbeddedPhone.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsAppToPerson creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UsAppToPerson.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.brandRegistrationSid != null) {
            request.addPostParam("BrandRegistrationSid", this.brandRegistrationSid);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.messageFlow != null) {
            request.addPostParam("MessageFlow", this.messageFlow);
        }
        if (this.messageSamples != null) {
            for (String prop : this.messageSamples) {
                request.addPostParam("MessageSamples", prop);
            }
        }
        if (this.usAppToPersonUsecase != null) {
            request.addPostParam("UsAppToPersonUsecase", this.usAppToPersonUsecase);
        }
        if (this.hasEmbeddedLinks != null) {
            request.addPostParam("HasEmbeddedLinks", this.hasEmbeddedLinks.toString());
        }
        if (this.hasEmbeddedPhone != null) {
            request.addPostParam("HasEmbeddedPhone", this.hasEmbeddedPhone.toString());
        }
        if (this.optInMessage != null) {
            request.addPostParam("OptInMessage", this.optInMessage);
        }
        if (this.optOutMessage != null) {
            request.addPostParam("OptOutMessage", this.optOutMessage);
        }
        if (this.helpMessage != null) {
            request.addPostParam("HelpMessage", this.helpMessage);
        }
        if (this.optInKeywords != null) {
            for (String prop : this.optInKeywords) {
                request.addPostParam("OptInKeywords", prop);
            }
        }
        if (this.optOutKeywords != null) {
            for (String prop : this.optOutKeywords) {
                request.addPostParam("OptOutKeywords", prop);
            }
        }
        if (this.helpKeywords != null) {
            for (String prop : this.helpKeywords) {
                request.addPostParam("HelpKeywords", prop);
            }
        }
        if (this.subscriberOptIn != null) {
            request.addPostParam("SubscriberOptIn", this.subscriberOptIn.toString());
        }
        if (this.ageGated != null) {
            request.addPostParam("AgeGated", this.ageGated.toString());
        }
        if (this.directLending != null) {
            request.addPostParam("DirectLending", this.directLending.toString());
        }
    }
}

