/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.service.UsAppToPersonCreator;
import com.twilio.rest.messaging.v1.service.UsAppToPersonDeleter;
import com.twilio.rest.messaging.v1.service.UsAppToPersonFetcher;
import com.twilio.rest.messaging.v1.service.UsAppToPersonReader;
import com.twilio.rest.messaging.v1.service.UsAppToPersonUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsAppToPerson
extends Resource {
    private static final long serialVersionUID = 1672467414686L;
    private final String sid;
    private final String accountSid;
    private final String brandRegistrationSid;
    private final String messagingServiceSid;
    private final String description;
    private final List<String> messageSamples;
    private final String usAppToPersonUsecase;
    private final Boolean hasEmbeddedLinks;
    private final Boolean hasEmbeddedPhone;
    private final Boolean subscriberOptIn;
    private final Boolean ageGated;
    private final Boolean directLending;
    private final String campaignStatus;
    private final String campaignId;
    private final Boolean isExternallyRegistered;
    private final Map<String, Object> rateLimits;
    private final String messageFlow;
    private final String optInMessage;
    private final String optOutMessage;
    private final String helpMessage;
    private final List<String> optInKeywords;
    private final List<String> optOutKeywords;
    private final List<String> helpKeywords;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Boolean mock;
    private final List<Map<String, Object>> errors;

    public static UsAppToPersonCreator creator(String pathMessagingServiceSid, String brandRegistrationSid, String description, String messageFlow, List<String> messageSamples, String usAppToPersonUsecase, Boolean hasEmbeddedLinks, Boolean hasEmbeddedPhone) {
        return new UsAppToPersonCreator(pathMessagingServiceSid, brandRegistrationSid, description, messageFlow, messageSamples, usAppToPersonUsecase, hasEmbeddedLinks, hasEmbeddedPhone);
    }

    public static UsAppToPersonDeleter deleter(String pathMessagingServiceSid, String pathSid) {
        return new UsAppToPersonDeleter(pathMessagingServiceSid, pathSid);
    }

    public static UsAppToPersonFetcher fetcher(String pathMessagingServiceSid, String pathSid) {
        return new UsAppToPersonFetcher(pathMessagingServiceSid, pathSid);
    }

    public static UsAppToPersonReader reader(String pathMessagingServiceSid) {
        return new UsAppToPersonReader(pathMessagingServiceSid);
    }

    public static UsAppToPersonUpdater updater(String pathMessagingServiceSid, String pathSid, Boolean hasEmbeddedLinks, Boolean hasEmbeddedPhone, List<String> messageSamples, String messageFlow, String description, Boolean ageGated, Boolean directLending) {
        return new UsAppToPersonUpdater(pathMessagingServiceSid, pathSid, hasEmbeddedLinks, hasEmbeddedPhone, messageSamples, messageFlow, description, ageGated, directLending);
    }

    public static UsAppToPerson fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UsAppToPerson.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UsAppToPerson fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UsAppToPerson.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UsAppToPerson(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="brand_registration_sid") String brandRegistrationSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="description") String description, @JsonProperty(value="message_samples") List<String> messageSamples, @JsonProperty(value="us_app_to_person_usecase") String usAppToPersonUsecase, @JsonProperty(value="has_embedded_links") Boolean hasEmbeddedLinks, @JsonProperty(value="has_embedded_phone") Boolean hasEmbeddedPhone, @JsonProperty(value="subscriber_opt_in") Boolean subscriberOptIn, @JsonProperty(value="age_gated") Boolean ageGated, @JsonProperty(value="direct_lending") Boolean directLending, @JsonProperty(value="campaign_status") String campaignStatus, @JsonProperty(value="campaign_id") String campaignId, @JsonProperty(value="is_externally_registered") Boolean isExternallyRegistered, @JsonProperty(value="rate_limits") Map<String, Object> rateLimits, @JsonProperty(value="message_flow") String messageFlow, @JsonProperty(value="opt_in_message") String optInMessage, @JsonProperty(value="opt_out_message") String optOutMessage, @JsonProperty(value="help_message") String helpMessage, @JsonProperty(value="opt_in_keywords") List<String> optInKeywords, @JsonProperty(value="opt_out_keywords") List<String> optOutKeywords, @JsonProperty(value="help_keywords") List<String> helpKeywords, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="mock") Boolean mock, @JsonProperty(value="errors") List<Map<String, Object>> errors) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.brandRegistrationSid = brandRegistrationSid;
        this.messagingServiceSid = messagingServiceSid;
        this.description = description;
        this.messageSamples = messageSamples;
        this.usAppToPersonUsecase = usAppToPersonUsecase;
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        this.hasEmbeddedPhone = hasEmbeddedPhone;
        this.subscriberOptIn = subscriberOptIn;
        this.ageGated = ageGated;
        this.directLending = directLending;
        this.campaignStatus = campaignStatus;
        this.campaignId = campaignId;
        this.isExternallyRegistered = isExternallyRegistered;
        this.rateLimits = rateLimits;
        this.messageFlow = messageFlow;
        this.optInMessage = optInMessage;
        this.optOutMessage = optOutMessage;
        this.helpMessage = helpMessage;
        this.optInKeywords = optInKeywords;
        this.optOutKeywords = optOutKeywords;
        this.helpKeywords = helpKeywords;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.mock = mock;
        this.errors = errors;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBrandRegistrationSid() {
        return this.brandRegistrationSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getDescription() {
        return this.description;
    }

    public final List<String> getMessageSamples() {
        return this.messageSamples;
    }

    public final String getUsAppToPersonUsecase() {
        return this.usAppToPersonUsecase;
    }

    public final Boolean getHasEmbeddedLinks() {
        return this.hasEmbeddedLinks;
    }

    public final Boolean getHasEmbeddedPhone() {
        return this.hasEmbeddedPhone;
    }

    public final Boolean getSubscriberOptIn() {
        return this.subscriberOptIn;
    }

    public final Boolean getAgeGated() {
        return this.ageGated;
    }

    public final Boolean getDirectLending() {
        return this.directLending;
    }

    public final String getCampaignStatus() {
        return this.campaignStatus;
    }

    public final String getCampaignId() {
        return this.campaignId;
    }

    public final Boolean getIsExternallyRegistered() {
        return this.isExternallyRegistered;
    }

    public final Map<String, Object> getRateLimits() {
        return this.rateLimits;
    }

    public final String getMessageFlow() {
        return this.messageFlow;
    }

    public final String getOptInMessage() {
        return this.optInMessage;
    }

    public final String getOptOutMessage() {
        return this.optOutMessage;
    }

    public final String getHelpMessage() {
        return this.helpMessage;
    }

    public final List<String> getOptInKeywords() {
        return this.optInKeywords;
    }

    public final List<String> getOptOutKeywords() {
        return this.optOutKeywords;
    }

    public final List<String> getHelpKeywords() {
        return this.helpKeywords;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getMock() {
        return this.mock;
    }

    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsAppToPerson other = (UsAppToPerson)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.brandRegistrationSid, other.brandRegistrationSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.description, other.description) && Objects.equals(this.messageSamples, other.messageSamples) && Objects.equals(this.usAppToPersonUsecase, other.usAppToPersonUsecase) && Objects.equals(this.hasEmbeddedLinks, other.hasEmbeddedLinks) && Objects.equals(this.hasEmbeddedPhone, other.hasEmbeddedPhone) && Objects.equals(this.subscriberOptIn, other.subscriberOptIn) && Objects.equals(this.ageGated, other.ageGated) && Objects.equals(this.directLending, other.directLending) && Objects.equals(this.campaignStatus, other.campaignStatus) && Objects.equals(this.campaignId, other.campaignId) && Objects.equals(this.isExternallyRegistered, other.isExternallyRegistered) && Objects.equals(this.rateLimits, other.rateLimits) && Objects.equals(this.messageFlow, other.messageFlow) && Objects.equals(this.optInMessage, other.optInMessage) && Objects.equals(this.optOutMessage, other.optOutMessage) && Objects.equals(this.helpMessage, other.helpMessage) && Objects.equals(this.optInKeywords, other.optInKeywords) && Objects.equals(this.optOutKeywords, other.optOutKeywords) && Objects.equals(this.helpKeywords, other.helpKeywords) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.mock, other.mock) && Objects.equals(this.errors, other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.brandRegistrationSid, this.messagingServiceSid, this.description, this.messageSamples, this.usAppToPersonUsecase, this.hasEmbeddedLinks, this.hasEmbeddedPhone, this.subscriberOptIn, this.ageGated, this.directLending, this.campaignStatus, this.campaignId, this.isExternallyRegistered, this.rateLimits, this.messageFlow, this.optInMessage, this.optOutMessage, this.helpMessage, this.optInKeywords, this.optOutKeywords, this.helpKeywords, this.dateCreated, this.dateUpdated, this.url, this.mock, this.errors);
    }

    public String toString() {
        return "UsAppToPerson(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", brandRegistrationSid=" + this.getBrandRegistrationSid() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", description=" + this.getDescription() + ", messageSamples=" + this.getMessageSamples() + ", usAppToPersonUsecase=" + this.getUsAppToPersonUsecase() + ", hasEmbeddedLinks=" + this.getHasEmbeddedLinks() + ", hasEmbeddedPhone=" + this.getHasEmbeddedPhone() + ", subscriberOptIn=" + this.getSubscriberOptIn() + ", ageGated=" + this.getAgeGated() + ", directLending=" + this.getDirectLending() + ", campaignStatus=" + this.getCampaignStatus() + ", campaignId=" + this.getCampaignId() + ", isExternallyRegistered=" + this.getIsExternallyRegistered() + ", rateLimits=" + this.getRateLimits() + ", messageFlow=" + this.getMessageFlow() + ", optInMessage=" + this.getOptInMessage() + ", optOutMessage=" + this.getOptOutMessage() + ", helpMessage=" + this.getHelpMessage() + ", optInKeywords=" + this.getOptInKeywords() + ", optOutKeywords=" + this.getOptOutKeywords() + ", helpKeywords=" + this.getHelpKeywords() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", mock=" + this.getMock() + ", errors=" + this.getErrors() + ")";
    }
}

