/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.PhoneNumber;

public class PhoneNumberCreator
extends Creator<PhoneNumber> {
    private String pathServiceSid;
    private String phoneNumberSid;

    public PhoneNumberCreator(String pathServiceSid, String phoneNumberSid) {
        this.pathServiceSid = pathServiceSid;
        this.phoneNumberSid = phoneNumberSid;
    }

    public PhoneNumberCreator setPhoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
        return this;
    }

    @Override
    public PhoneNumber create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/PhoneNumbers";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{PhoneNumberSid}", this.phoneNumberSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumberSid != null) {
            request.addPostParam("PhoneNumberSid", this.phoneNumberSid);
        }
    }
}

