/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.brandregistration;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.brandregistration.BrandVetting;

public class BrandVettingCreator
extends Creator<BrandVetting> {
    private String pathBrandSid;
    private BrandVetting.VettingProvider vettingProvider;
    private String vettingId;

    public BrandVettingCreator(String pathBrandSid, BrandVetting.VettingProvider vettingProvider) {
        this.pathBrandSid = pathBrandSid;
        this.vettingProvider = vettingProvider;
    }

    public BrandVettingCreator setVettingProvider(BrandVetting.VettingProvider vettingProvider) {
        this.vettingProvider = vettingProvider;
        return this;
    }

    public BrandVettingCreator setVettingId(String vettingId) {
        this.vettingId = vettingId;
        return this;
    }

    @Override
    public BrandVetting create(TwilioRestClient client) {
        String path = "/v1/a2p/BrandRegistrations/{BrandSid}/Vettings";
        path = path.replace("{BrandSid}", this.pathBrandSid.toString());
        path = path.replace("{VettingProvider}", this.vettingProvider.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandVetting creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BrandVetting.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.vettingProvider != null) {
            request.addPostParam("VettingProvider", this.vettingProvider.toString());
        }
        if (this.vettingId != null) {
            request.addPostParam("VettingId", this.vettingId);
        }
    }
}

