/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.brandregistration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.brandregistration.BrandRegistrationOtpCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandRegistrationOtp
extends Resource {
    private static final long serialVersionUID = 131615733171627L;
    private final String accountSid;
    private final String brandRegistrationSid;

    public static BrandRegistrationOtpCreator creator(String pathBrandRegistrationSid) {
        return new BrandRegistrationOtpCreator(pathBrandRegistrationSid);
    }

    public static BrandRegistrationOtp fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandRegistrationOtp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandRegistrationOtp fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandRegistrationOtp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandRegistrationOtp(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="brand_registration_sid") String brandRegistrationSid) {
        this.accountSid = accountSid;
        this.brandRegistrationSid = brandRegistrationSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBrandRegistrationSid() {
        return this.brandRegistrationSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandRegistrationOtp other = (BrandRegistrationOtp)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.brandRegistrationSid, other.brandRegistrationSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.brandRegistrationSid);
    }

    public String toString() {
        return "BrandRegistrationOtp(accountSid=" + this.getAccountSid() + ", brandRegistrationSid=" + this.getBrandRegistrationSid() + ")";
    }
}

