/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Service;
import java.net.URI;

public class ServiceUpdater
extends Updater<Service> {
    private String pathSid;
    private String friendlyName;
    private URI inboundRequestUrl;
    private HttpMethod inboundMethod;
    private URI fallbackUrl;
    private HttpMethod fallbackMethod;
    private URI statusCallback;
    private Boolean stickySender;
    private Boolean mmsConverter;
    private Boolean smartEncoding;
    private Service.ScanMessageContent scanMessageContent;
    private Boolean fallbackToLongCode;
    private Boolean areaCodeGeomatch;
    private Integer validityPeriod;
    private Boolean synchronousValidation;
    private String usecase;
    private Boolean useInboundWebhookOnNumber;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setInboundRequestUrl(URI inboundRequestUrl) {
        this.inboundRequestUrl = inboundRequestUrl;
        return this;
    }

    public ServiceUpdater setInboundRequestUrl(String inboundRequestUrl) {
        return this.setInboundRequestUrl(Promoter.uriFromString(inboundRequestUrl));
    }

    public ServiceUpdater setInboundMethod(HttpMethod inboundMethod) {
        this.inboundMethod = inboundMethod;
        return this;
    }

    public ServiceUpdater setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public ServiceUpdater setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public ServiceUpdater setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public ServiceUpdater setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ServiceUpdater setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ServiceUpdater setStickySender(Boolean stickySender) {
        this.stickySender = stickySender;
        return this;
    }

    public ServiceUpdater setMmsConverter(Boolean mmsConverter) {
        this.mmsConverter = mmsConverter;
        return this;
    }

    public ServiceUpdater setSmartEncoding(Boolean smartEncoding) {
        this.smartEncoding = smartEncoding;
        return this;
    }

    public ServiceUpdater setScanMessageContent(Service.ScanMessageContent scanMessageContent) {
        this.scanMessageContent = scanMessageContent;
        return this;
    }

    public ServiceUpdater setFallbackToLongCode(Boolean fallbackToLongCode) {
        this.fallbackToLongCode = fallbackToLongCode;
        return this;
    }

    public ServiceUpdater setAreaCodeGeomatch(Boolean areaCodeGeomatch) {
        this.areaCodeGeomatch = areaCodeGeomatch;
        return this;
    }

    public ServiceUpdater setValidityPeriod(Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public ServiceUpdater setSynchronousValidation(Boolean synchronousValidation) {
        this.synchronousValidation = synchronousValidation;
        return this;
    }

    public ServiceUpdater setUsecase(String usecase) {
        this.usecase = usecase;
        return this;
    }

    public ServiceUpdater setUseInboundWebhookOnNumber(Boolean useInboundWebhookOnNumber) {
        this.useInboundWebhookOnNumber = useInboundWebhookOnNumber;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        String path = "/v1/Services/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.inboundRequestUrl != null) {
            request.addPostParam("InboundRequestUrl", this.inboundRequestUrl.toString());
        }
        if (this.inboundMethod != null) {
            request.addPostParam("InboundMethod", this.inboundMethod.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.stickySender != null) {
            request.addPostParam("StickySender", this.stickySender.toString());
        }
        if (this.mmsConverter != null) {
            request.addPostParam("MmsConverter", this.mmsConverter.toString());
        }
        if (this.smartEncoding != null) {
            request.addPostParam("SmartEncoding", this.smartEncoding.toString());
        }
        if (this.scanMessageContent != null) {
            request.addPostParam("ScanMessageContent", this.scanMessageContent.toString());
        }
        if (this.fallbackToLongCode != null) {
            request.addPostParam("FallbackToLongCode", this.fallbackToLongCode.toString());
        }
        if (this.areaCodeGeomatch != null) {
            request.addPostParam("AreaCodeGeomatch", this.areaCodeGeomatch.toString());
        }
        if (this.validityPeriod != null) {
            request.addPostParam("ValidityPeriod", this.validityPeriod.toString());
        }
        if (this.synchronousValidation != null) {
            request.addPostParam("SynchronousValidation", this.synchronousValidation.toString());
        }
        if (this.usecase != null) {
            request.addPostParam("Usecase", this.usecase);
        }
        if (this.useInboundWebhookOnNumber != null) {
            request.addPostParam("UseInboundWebhookOnNumber", this.useInboundWebhookOnNumber.toString());
        }
    }
}

