/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.LinkshorteningMessagingServiceDomainAssociationFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LinkshorteningMessagingServiceDomainAssociation
extends Resource {
    private static final long serialVersionUID = 242981332247911L;
    private final String domainSid;
    private final String messagingServiceSid;
    private final URI url;

    public static LinkshorteningMessagingServiceDomainAssociationFetcher fetcher(String pathMessagingServiceSid) {
        return new LinkshorteningMessagingServiceDomainAssociationFetcher(pathMessagingServiceSid);
    }

    public static LinkshorteningMessagingServiceDomainAssociation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, LinkshorteningMessagingServiceDomainAssociation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static LinkshorteningMessagingServiceDomainAssociation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, LinkshorteningMessagingServiceDomainAssociation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private LinkshorteningMessagingServiceDomainAssociation(@JsonProperty(value="domain_sid") String domainSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="url") URI url) {
        this.domainSid = domainSid;
        this.messagingServiceSid = messagingServiceSid;
        this.url = url;
    }

    public final String getDomainSid() {
        return this.domainSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkshorteningMessagingServiceDomainAssociation other = (LinkshorteningMessagingServiceDomainAssociation)o;
        return Objects.equals(this.domainSid, other.domainSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.domainSid, this.messagingServiceSid, this.url);
    }

    public String toString() {
        return "LinkshorteningMessagingServiceDomainAssociation(domainSid=" + this.getDomainSid() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", url=" + this.getUrl() + ")";
    }
}

