/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.BrandRegistrationCreator;
import com.twilio.rest.messaging.v1.BrandRegistrationFetcher;
import com.twilio.rest.messaging.v1.BrandRegistrationReader;
import com.twilio.rest.messaging.v1.BrandRegistrationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandRegistration
extends Resource {
    private static final long serialVersionUID = 138336370956862L;
    private final String sid;
    private final String accountSid;
    private final String customerProfileBundleSid;
    private final String a2pProfileBundleSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String brandType;
    private final Status status;
    private final String tcrId;
    private final String failureReason;
    private final List<Map<String, Object>> errors;
    private final URI url;
    private final Integer brandScore;
    private final List<BrandFeedback> brandFeedback;
    private final IdentityStatus identityStatus;
    private final Boolean russell3000;
    private final Boolean governmentEntity;
    private final String taxExemptStatus;
    private final Boolean skipAutomaticSecVet;
    private final Boolean mock;
    private final Map<String, String> links;

    public static BrandRegistrationCreator creator(String customerProfileBundleSid, String a2PProfileBundleSid) {
        return new BrandRegistrationCreator(customerProfileBundleSid, a2PProfileBundleSid);
    }

    public static BrandRegistrationFetcher fetcher(String pathSid) {
        return new BrandRegistrationFetcher(pathSid);
    }

    public static BrandRegistrationReader reader() {
        return new BrandRegistrationReader();
    }

    public static BrandRegistrationUpdater updater(String pathSid) {
        return new BrandRegistrationUpdater(pathSid);
    }

    public static BrandRegistration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandRegistration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandRegistration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandRegistration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandRegistration(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="customer_profile_bundle_sid") String customerProfileBundleSid, @JsonProperty(value="a2p_profile_bundle_sid") String a2pProfileBundleSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="brand_type") String brandType, @JsonProperty(value="status") Status status, @JsonProperty(value="tcr_id") String tcrId, @JsonProperty(value="failure_reason") String failureReason, @JsonProperty(value="errors") List<Map<String, Object>> errors, @JsonProperty(value="url") URI url, @JsonProperty(value="brand_score") Integer brandScore, @JsonProperty(value="brand_feedback") List<BrandFeedback> brandFeedback, @JsonProperty(value="identity_status") IdentityStatus identityStatus, @JsonProperty(value="russell3000") Boolean russell3000, @JsonProperty(value="government_entity") Boolean governmentEntity, @JsonProperty(value="tax_exempt_status") String taxExemptStatus, @JsonProperty(value="skip_automatic_sec_vet") Boolean skipAutomaticSecVet, @JsonProperty(value="mock") Boolean mock, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.customerProfileBundleSid = customerProfileBundleSid;
        this.a2pProfileBundleSid = a2pProfileBundleSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.brandType = brandType;
        this.status = status;
        this.tcrId = tcrId;
        this.failureReason = failureReason;
        this.errors = errors;
        this.url = url;
        this.brandScore = brandScore;
        this.brandFeedback = brandFeedback;
        this.identityStatus = identityStatus;
        this.russell3000 = russell3000;
        this.governmentEntity = governmentEntity;
        this.taxExemptStatus = taxExemptStatus;
        this.skipAutomaticSecVet = skipAutomaticSecVet;
        this.mock = mock;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCustomerProfileBundleSid() {
        return this.customerProfileBundleSid;
    }

    public final String getA2pProfileBundleSid() {
        return this.a2pProfileBundleSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getBrandType() {
        return this.brandType;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getTcrId() {
        return this.tcrId;
    }

    public final String getFailureReason() {
        return this.failureReason;
    }

    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Integer getBrandScore() {
        return this.brandScore;
    }

    public final List<BrandFeedback> getBrandFeedback() {
        return this.brandFeedback;
    }

    public final IdentityStatus getIdentityStatus() {
        return this.identityStatus;
    }

    public final Boolean getRussell3000() {
        return this.russell3000;
    }

    public final Boolean getGovernmentEntity() {
        return this.governmentEntity;
    }

    public final String getTaxExemptStatus() {
        return this.taxExemptStatus;
    }

    public final Boolean getSkipAutomaticSecVet() {
        return this.skipAutomaticSecVet;
    }

    public final Boolean getMock() {
        return this.mock;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandRegistration other = (BrandRegistration)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.customerProfileBundleSid, other.customerProfileBundleSid) && Objects.equals(this.a2pProfileBundleSid, other.a2pProfileBundleSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.brandType, other.brandType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.tcrId, other.tcrId) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.errors, other.errors) && Objects.equals(this.url, other.url) && Objects.equals(this.brandScore, other.brandScore) && Objects.equals(this.brandFeedback, other.brandFeedback) && Objects.equals((Object)this.identityStatus, (Object)other.identityStatus) && Objects.equals(this.russell3000, other.russell3000) && Objects.equals(this.governmentEntity, other.governmentEntity) && Objects.equals(this.taxExemptStatus, other.taxExemptStatus) && Objects.equals(this.skipAutomaticSecVet, other.skipAutomaticSecVet) && Objects.equals(this.mock, other.mock) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.customerProfileBundleSid, this.a2pProfileBundleSid, this.dateCreated, this.dateUpdated, this.brandType, this.status, this.tcrId, this.failureReason, this.errors, this.url, this.brandScore, this.brandFeedback, this.identityStatus, this.russell3000, this.governmentEntity, this.taxExemptStatus, this.skipAutomaticSecVet, this.mock, this.links});
    }

    public String toString() {
        return "BrandRegistration(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", customerProfileBundleSid=" + this.getCustomerProfileBundleSid() + ", a2pProfileBundleSid=" + this.getA2pProfileBundleSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", brandType=" + this.getBrandType() + ", status=" + (Object)((Object)this.getStatus()) + ", tcrId=" + this.getTcrId() + ", failureReason=" + this.getFailureReason() + ", errors=" + this.getErrors() + ", url=" + this.getUrl() + ", brandScore=" + this.getBrandScore() + ", brandFeedback=" + this.getBrandFeedback() + ", identityStatus=" + (Object)((Object)this.getIdentityStatus()) + ", russell3000=" + this.getRussell3000() + ", governmentEntity=" + this.getGovernmentEntity() + ", taxExemptStatus=" + this.getTaxExemptStatus() + ", skipAutomaticSecVet=" + this.getSkipAutomaticSecVet() + ", mock=" + this.getMock() + ", links=" + this.getLinks() + ")";
    }

    public static enum IdentityStatus {
        SELF_DECLARED("SELF_DECLARED"),
        UNVERIFIED("UNVERIFIED"),
        VERIFIED("VERIFIED"),
        VETTED_VERIFIED("VETTED_VERIFIED");

        private final String value;

        private IdentityStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static IdentityStatus forValue(String value) {
            return (IdentityStatus)Promoter.enumFromString((String)value, (Enum[])IdentityStatus.values());
        }
    }

    public static enum BrandFeedback {
        TAX_ID("TAX_ID"),
        STOCK_SYMBOL("STOCK_SYMBOL"),
        NONPROFIT("NONPROFIT"),
        GOVERNMENT_ENTITY("GOVERNMENT_ENTITY"),
        OTHERS("OTHERS");

        private final String value;

        private BrandFeedback(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BrandFeedback forValue(String value) {
            return (BrandFeedback)Promoter.enumFromString((String)value, (Enum[])BrandFeedback.values());
        }
    }

    public static enum Status {
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        FAILED("FAILED"),
        IN_REVIEW("IN_REVIEW"),
        DELETED("DELETED");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

