/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.channel;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.channel.Invite;

public class InviteDeleter
extends Deleter<Invite> {
    private String pathServiceSid;
    private String pathChannelSid;
    private String pathSid;

    public InviteDeleter(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Channels/{ChannelSid}/Invites/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.IPMESSAGING.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Invite delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

