/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service.channel;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.channel.Message;

public class MessageUpdater
extends Updater<Message> {
    private String pathServiceSid;
    private String pathChannelSid;
    private String pathSid;
    private String body;
    private String attributes;

    public MessageUpdater(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    public MessageUpdater setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Message update(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Channels/{ChannelSid}/Messages/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

