/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.transcript.OperatorResultFetcher;
import com.twilio.rest.intelligence.v2.transcript.OperatorResultReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatorResult
extends Resource {
    private static final long serialVersionUID = 197278046028453L;
    private final OperatorType operatorType;
    private final String name;
    private final String operatorSid;
    private final Boolean extractMatch;
    private final BigDecimal matchProbability;
    private final String normalizedResult;
    private final List<Map<String, Object>> utteranceResults;
    private final Boolean utteranceMatch;
    private final String predictedLabel;
    private final BigDecimal predictedProbability;
    private final Map<String, Object> labelProbabilities;
    private final Map<String, Object> extractResults;
    private final Map<String, Object> textGenerationResults;
    private final String transcriptSid;
    private final URI url;

    public static OperatorResultFetcher fetcher(String pathTranscriptSid, String pathOperatorSid) {
        return new OperatorResultFetcher(pathTranscriptSid, pathOperatorSid);
    }

    public static OperatorResultReader reader(String pathTranscriptSid) {
        return new OperatorResultReader(pathTranscriptSid);
    }

    public static OperatorResult fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OperatorResult fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OperatorResult(@JsonProperty(value="operator_type") OperatorType operatorType, @JsonProperty(value="name") String name, @JsonProperty(value="operator_sid") String operatorSid, @JsonProperty(value="extract_match") Boolean extractMatch, @JsonProperty(value="match_probability") BigDecimal matchProbability, @JsonProperty(value="normalized_result") String normalizedResult, @JsonProperty(value="utterance_results") List<Map<String, Object>> utteranceResults, @JsonProperty(value="utterance_match") Boolean utteranceMatch, @JsonProperty(value="predicted_label") String predictedLabel, @JsonProperty(value="predicted_probability") BigDecimal predictedProbability, @JsonProperty(value="label_probabilities") Map<String, Object> labelProbabilities, @JsonProperty(value="extract_results") Map<String, Object> extractResults, @JsonProperty(value="text_generation_results") Map<String, Object> textGenerationResults, @JsonProperty(value="transcript_sid") String transcriptSid, @JsonProperty(value="url") URI url) {
        this.operatorType = operatorType;
        this.name = name;
        this.operatorSid = operatorSid;
        this.extractMatch = extractMatch;
        this.matchProbability = matchProbability;
        this.normalizedResult = normalizedResult;
        this.utteranceResults = utteranceResults;
        this.utteranceMatch = utteranceMatch;
        this.predictedLabel = predictedLabel;
        this.predictedProbability = predictedProbability;
        this.labelProbabilities = labelProbabilities;
        this.extractResults = extractResults;
        this.textGenerationResults = textGenerationResults;
        this.transcriptSid = transcriptSid;
        this.url = url;
    }

    public final OperatorType getOperatorType() {
        return this.operatorType;
    }

    public final String getName() {
        return this.name;
    }

    public final String getOperatorSid() {
        return this.operatorSid;
    }

    public final Boolean getExtractMatch() {
        return this.extractMatch;
    }

    public final BigDecimal getMatchProbability() {
        return this.matchProbability;
    }

    public final String getNormalizedResult() {
        return this.normalizedResult;
    }

    public final List<Map<String, Object>> getUtteranceResults() {
        return this.utteranceResults;
    }

    public final Boolean getUtteranceMatch() {
        return this.utteranceMatch;
    }

    public final String getPredictedLabel() {
        return this.predictedLabel;
    }

    public final BigDecimal getPredictedProbability() {
        return this.predictedProbability;
    }

    public final Map<String, Object> getLabelProbabilities() {
        return this.labelProbabilities;
    }

    public final Map<String, Object> getExtractResults() {
        return this.extractResults;
    }

    public final Map<String, Object> getTextGenerationResults() {
        return this.textGenerationResults;
    }

    public final String getTranscriptSid() {
        return this.transcriptSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorResult other = (OperatorResult)o;
        return Objects.equals((Object)this.operatorType, (Object)other.operatorType) && Objects.equals(this.name, other.name) && Objects.equals(this.operatorSid, other.operatorSid) && Objects.equals(this.extractMatch, other.extractMatch) && Objects.equals(this.matchProbability, other.matchProbability) && Objects.equals(this.normalizedResult, other.normalizedResult) && Objects.equals(this.utteranceResults, other.utteranceResults) && Objects.equals(this.utteranceMatch, other.utteranceMatch) && Objects.equals(this.predictedLabel, other.predictedLabel) && Objects.equals(this.predictedProbability, other.predictedProbability) && Objects.equals(this.labelProbabilities, other.labelProbabilities) && Objects.equals(this.extractResults, other.extractResults) && Objects.equals(this.textGenerationResults, other.textGenerationResults) && Objects.equals(this.transcriptSid, other.transcriptSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operatorType, this.name, this.operatorSid, this.extractMatch, this.matchProbability, this.normalizedResult, this.utteranceResults, this.utteranceMatch, this.predictedLabel, this.predictedProbability, this.labelProbabilities, this.extractResults, this.textGenerationResults, this.transcriptSid, this.url});
    }

    public String toString() {
        return "OperatorResult(operatorType=" + (Object)((Object)this.getOperatorType()) + ", name=" + this.getName() + ", operatorSid=" + this.getOperatorSid() + ", extractMatch=" + this.getExtractMatch() + ", matchProbability=" + this.getMatchProbability() + ", normalizedResult=" + this.getNormalizedResult() + ", utteranceResults=" + this.getUtteranceResults() + ", utteranceMatch=" + this.getUtteranceMatch() + ", predictedLabel=" + this.getPredictedLabel() + ", predictedProbability=" + this.getPredictedProbability() + ", labelProbabilities=" + this.getLabelProbabilities() + ", extractResults=" + this.getExtractResults() + ", textGenerationResults=" + this.getTextGenerationResults() + ", transcriptSid=" + this.getTranscriptSid() + ", url=" + this.getUrl() + ")";
    }

    public static enum OperatorType {
        CONVERSATION_CLASSIFY("conversation_classify"),
        UTTERANCE_CLASSIFY("utterance_classify"),
        EXTRACT("extract"),
        EXTRACT_NORMALIZE("extract_normalize"),
        PII_EXTRACT("pii_extract");

        private final String value;

        private OperatorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static OperatorType forValue(String value) {
            return (OperatorType)Promoter.enumFromString((String)value, (Enum[])OperatorType.values());
        }
    }
}

