/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.Transcript;

public class TranscriptReader
extends Reader<Transcript> {
    private String serviceSid;
    private String beforeStartTime;
    private String afterStartTime;
    private String beforeDateCreated;
    private String afterDateCreated;
    private String status;
    private String languageCode;
    private String sourceSid;
    private Integer pageSize;

    public TranscriptReader setServiceSid(String serviceSid) {
        this.serviceSid = serviceSid;
        return this;
    }

    public TranscriptReader setBeforeStartTime(String beforeStartTime) {
        this.beforeStartTime = beforeStartTime;
        return this;
    }

    public TranscriptReader setAfterStartTime(String afterStartTime) {
        this.afterStartTime = afterStartTime;
        return this;
    }

    public TranscriptReader setBeforeDateCreated(String beforeDateCreated) {
        this.beforeDateCreated = beforeDateCreated;
        return this;
    }

    public TranscriptReader setAfterDateCreated(String afterDateCreated) {
        this.afterDateCreated = afterDateCreated;
        return this;
    }

    public TranscriptReader setStatus(String status) {
        this.status = status;
        return this;
    }

    public TranscriptReader setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    public TranscriptReader setSourceSid(String sourceSid) {
        this.sourceSid = sourceSid;
        return this;
    }

    public TranscriptReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Transcript> read(TwilioRestClient client) {
        return new ResourceSet<Transcript>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Transcript> firstPage(TwilioRestClient client) {
        String path = "/v2/Transcripts";
        Request request = new Request(HttpMethod.GET, Domains.INTELLIGENCE.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Transcript> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Transcript read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("transcripts", response.getContent(), Transcript.class, client.getObjectMapper());
    }

    @Override
    public Page<Transcript> previousPage(Page<Transcript> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Transcript> nextPage(Page<Transcript> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Transcript> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.serviceSid != null) {
            request.addQueryParam("ServiceSid", this.serviceSid);
        }
        if (this.beforeStartTime != null) {
            request.addQueryParam("BeforeStartTime", this.beforeStartTime);
        }
        if (this.afterStartTime != null) {
            request.addQueryParam("AfterStartTime", this.afterStartTime);
        }
        if (this.beforeDateCreated != null) {
            request.addQueryParam("BeforeDateCreated", this.beforeDateCreated);
        }
        if (this.afterDateCreated != null) {
            request.addQueryParam("AfterDateCreated", this.afterDateCreated);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.languageCode != null) {
            request.addQueryParam("LanguageCode", this.languageCode);
        }
        if (this.sourceSid != null) {
            request.addQueryParam("SourceSid", this.sourceSid);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

