/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.TranscriptCreator;
import com.twilio.rest.intelligence.v2.TranscriptDeleter;
import com.twilio.rest.intelligence.v2.TranscriptFetcher;
import com.twilio.rest.intelligence.v2.TranscriptReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Transcript
extends Resource {
    private static final long serialVersionUID = 35462753187463L;
    private final String accountSid;
    private final String serviceSid;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Status status;
    private final Map<String, Object> channel;
    private final Boolean dataLogging;
    private final String languageCode;
    private final String customerKey;
    private final ZonedDateTime mediaStartTime;
    private final Integer duration;
    private final URI url;
    private final Boolean redaction;
    private final Map<String, String> links;

    public static TranscriptCreator creator(String serviceSid, Map<String, Object> channel) {
        return new TranscriptCreator(serviceSid, channel);
    }

    public static TranscriptDeleter deleter(String pathSid) {
        return new TranscriptDeleter(pathSid);
    }

    public static TranscriptFetcher fetcher(String pathSid) {
        return new TranscriptFetcher(pathSid);
    }

    public static TranscriptReader reader() {
        return new TranscriptReader();
    }

    public static Transcript fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Transcript.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Transcript fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Transcript.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Transcript(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="status") Status status, @JsonProperty(value="channel") Map<String, Object> channel, @JsonProperty(value="data_logging") Boolean dataLogging, @JsonProperty(value="language_code") String languageCode, @JsonProperty(value="customer_key") String customerKey, @JsonProperty(value="media_start_time") String mediaStartTime, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="url") URI url, @JsonProperty(value="redaction") Boolean redaction, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.status = status;
        this.channel = channel;
        this.dataLogging = dataLogging;
        this.languageCode = languageCode;
        this.customerKey = customerKey;
        this.mediaStartTime = DateConverter.iso8601DateTimeFromString(mediaStartTime);
        this.duration = duration;
        this.url = url;
        this.redaction = redaction;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Map<String, Object> getChannel() {
        return this.channel;
    }

    public final Boolean getDataLogging() {
        return this.dataLogging;
    }

    public final String getLanguageCode() {
        return this.languageCode;
    }

    public final String getCustomerKey() {
        return this.customerKey;
    }

    public final ZonedDateTime getMediaStartTime() {
        return this.mediaStartTime;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getRedaction() {
        return this.redaction;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transcript other = (Transcript)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.channel, other.channel) && Objects.equals(this.dataLogging, other.dataLogging) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.customerKey, other.customerKey) && Objects.equals(this.mediaStartTime, other.mediaStartTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.url, other.url) && Objects.equals(this.redaction, other.redaction) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.serviceSid, this.sid, this.dateCreated, this.dateUpdated, this.status, this.channel, this.dataLogging, this.languageCode, this.customerKey, this.mediaStartTime, this.duration, this.url, this.redaction, this.links});
    }

    public String toString() {
        return "Transcript(accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", status=" + (Object)((Object)this.getStatus()) + ", channel=" + this.getChannel() + ", dataLogging=" + this.getDataLogging() + ", languageCode=" + this.getLanguageCode() + ", customerKey=" + this.getCustomerKey() + ", mediaStartTime=" + this.getMediaStartTime() + ", duration=" + this.getDuration() + ", url=" + this.getUrl() + ", redaction=" + this.getRedaction() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        QUEUED("queued"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

