/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.ServiceCreator;
import com.twilio.rest.intelligence.v2.ServiceDeleter;
import com.twilio.rest.intelligence.v2.ServiceFetcher;
import com.twilio.rest.intelligence.v2.ServiceReader;
import com.twilio.rest.intelligence.v2.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 160239821590245L;
    private final String accountSid;
    private final Boolean autoRedaction;
    private final Boolean mediaRedaction;
    private final Boolean autoTranscribe;
    private final Boolean dataLogging;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String languageCode;
    private final String sid;
    private final String uniqueName;
    private final URI url;
    private final String webhookUrl;
    private final HttpMethod webhookHttpMethod;
    private final Integer version;

    public static ServiceCreator creator(String uniqueName) {
        return new ServiceCreator(uniqueName);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="auto_redaction") Boolean autoRedaction, @JsonProperty(value="media_redaction") Boolean mediaRedaction, @JsonProperty(value="auto_transcribe") Boolean autoTranscribe, @JsonProperty(value="data_logging") Boolean dataLogging, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="language_code") String languageCode, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url, @JsonProperty(value="webhook_url") String webhookUrl, @JsonProperty(value="webhook_http_method") HttpMethod webhookHttpMethod, @JsonProperty(value="version") Integer version) {
        this.accountSid = accountSid;
        this.autoRedaction = autoRedaction;
        this.mediaRedaction = mediaRedaction;
        this.autoTranscribe = autoTranscribe;
        this.dataLogging = dataLogging;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.languageCode = languageCode;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.url = url;
        this.webhookUrl = webhookUrl;
        this.webhookHttpMethod = webhookHttpMethod;
        this.version = version;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getAutoRedaction() {
        return this.autoRedaction;
    }

    public final Boolean getMediaRedaction() {
        return this.mediaRedaction;
    }

    public final Boolean getAutoTranscribe() {
        return this.autoTranscribe;
    }

    public final Boolean getDataLogging() {
        return this.dataLogging;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLanguageCode() {
        return this.languageCode;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getWebhookUrl() {
        return this.webhookUrl;
    }

    public final HttpMethod getWebhookHttpMethod() {
        return this.webhookHttpMethod;
    }

    public final Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.autoRedaction, other.autoRedaction) && Objects.equals(this.mediaRedaction, other.mediaRedaction) && Objects.equals(this.autoTranscribe, other.autoTranscribe) && Objects.equals(this.dataLogging, other.dataLogging) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals((Object)this.webhookHttpMethod, (Object)other.webhookHttpMethod) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.autoRedaction, this.mediaRedaction, this.autoTranscribe, this.dataLogging, this.dateCreated, this.dateUpdated, this.friendlyName, this.languageCode, this.sid, this.uniqueName, this.url, this.webhookUrl, this.webhookHttpMethod, this.version});
    }

    public String toString() {
        return "Service(accountSid=" + this.getAccountSid() + ", autoRedaction=" + this.getAutoRedaction() + ", mediaRedaction=" + this.getMediaRedaction() + ", autoTranscribe=" + this.getAutoTranscribe() + ", dataLogging=" + this.getDataLogging() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", languageCode=" + this.getLanguageCode() + ", sid=" + this.getSid() + ", uniqueName=" + this.getUniqueName() + ", url=" + this.getUrl() + ", webhookUrl=" + this.getWebhookUrl() + ", webhookHttpMethod=" + (Object)((Object)this.getWebhookHttpMethod()) + ", version=" + this.getVersion() + ")";
    }

    public static enum HttpMethod {
        GET("GET"),
        POST("POST"),
        NULL("NULL");

        private final String value;

        private HttpMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static HttpMethod forValue(String value) {
            return (HttpMethod)Promoter.enumFromString((String)value, (Enum[])HttpMethod.values());
        }
    }
}

