/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.conference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.conference.ConferenceParticipantFetcher;
import com.twilio.rest.insights.v1.conference.ConferenceParticipantReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConferenceParticipant
extends Resource {
    private static final long serialVersionUID = 67216866718855L;
    private final String participantSid;
    private final String label;
    private final String conferenceSid;
    private final String callSid;
    private final String accountSid;
    private final CallDirection callDirection;
    private final String from;
    private final String to;
    private final CallStatus callStatus;
    private final String countryCode;
    private final Boolean isModerator;
    private final ZonedDateTime joinTime;
    private final ZonedDateTime leaveTime;
    private final Integer durationSeconds;
    private final Integer outboundQueueLength;
    private final Integer outboundTimeInQueue;
    private final JitterBufferSize jitterBufferSize;
    private final Boolean isCoach;
    private final List<String> coachedParticipants;
    private final Region participantRegion;
    private final Region conferenceRegion;
    private final CallType callType;
    private final ProcessingState processingState;
    private final Map<String, Object> properties;
    private final Map<String, Object> events;
    private final Map<String, Object> metrics;
    private final URI url;

    public static ConferenceParticipantFetcher fetcher(String pathConferenceSid, String pathParticipantSid) {
        return new ConferenceParticipantFetcher(pathConferenceSid, pathParticipantSid);
    }

    public static ConferenceParticipantReader reader(String pathConferenceSid) {
        return new ConferenceParticipantReader(pathConferenceSid);
    }

    public static ConferenceParticipant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ConferenceParticipant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ConferenceParticipant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ConferenceParticipant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ConferenceParticipant(@JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="label") String label, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_direction") CallDirection callDirection, @JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="call_status") CallStatus callStatus, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="is_moderator") Boolean isModerator, @JsonProperty(value="join_time") String joinTime, @JsonProperty(value="leave_time") String leaveTime, @JsonProperty(value="duration_seconds") Integer durationSeconds, @JsonProperty(value="outbound_queue_length") Integer outboundQueueLength, @JsonProperty(value="outbound_time_in_queue") Integer outboundTimeInQueue, @JsonProperty(value="jitter_buffer_size") JitterBufferSize jitterBufferSize, @JsonProperty(value="is_coach") Boolean isCoach, @JsonProperty(value="coached_participants") List<String> coachedParticipants, @JsonProperty(value="participant_region") Region participantRegion, @JsonProperty(value="conference_region") Region conferenceRegion, @JsonProperty(value="call_type") CallType callType, @JsonProperty(value="processing_state") ProcessingState processingState, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="events") Map<String, Object> events, @JsonProperty(value="metrics") Map<String, Object> metrics, @JsonProperty(value="url") URI url) {
        this.participantSid = participantSid;
        this.label = label;
        this.conferenceSid = conferenceSid;
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.callDirection = callDirection;
        this.from = from;
        this.to = to;
        this.callStatus = callStatus;
        this.countryCode = countryCode;
        this.isModerator = isModerator;
        this.joinTime = DateConverter.iso8601DateTimeFromString(joinTime);
        this.leaveTime = DateConverter.iso8601DateTimeFromString(leaveTime);
        this.durationSeconds = durationSeconds;
        this.outboundQueueLength = outboundQueueLength;
        this.outboundTimeInQueue = outboundTimeInQueue;
        this.jitterBufferSize = jitterBufferSize;
        this.isCoach = isCoach;
        this.coachedParticipants = coachedParticipants;
        this.participantRegion = participantRegion;
        this.conferenceRegion = conferenceRegion;
        this.callType = callType;
        this.processingState = processingState;
        this.properties = properties;
        this.events = events;
        this.metrics = metrics;
        this.url = url;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final CallDirection getCallDirection() {
        return this.callDirection;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getTo() {
        return this.to;
    }

    public final CallStatus getCallStatus() {
        return this.callStatus;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final Boolean getIsModerator() {
        return this.isModerator;
    }

    public final ZonedDateTime getJoinTime() {
        return this.joinTime;
    }

    public final ZonedDateTime getLeaveTime() {
        return this.leaveTime;
    }

    public final Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public final Integer getOutboundQueueLength() {
        return this.outboundQueueLength;
    }

    public final Integer getOutboundTimeInQueue() {
        return this.outboundTimeInQueue;
    }

    public final JitterBufferSize getJitterBufferSize() {
        return this.jitterBufferSize;
    }

    public final Boolean getIsCoach() {
        return this.isCoach;
    }

    public final List<String> getCoachedParticipants() {
        return this.coachedParticipants;
    }

    public final Region getParticipantRegion() {
        return this.participantRegion;
    }

    public final Region getConferenceRegion() {
        return this.conferenceRegion;
    }

    public final CallType getCallType() {
        return this.callType;
    }

    public final ProcessingState getProcessingState() {
        return this.processingState;
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final Map<String, Object> getEvents() {
        return this.events;
    }

    public final Map<String, Object> getMetrics() {
        return this.metrics;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConferenceParticipant other = (ConferenceParticipant)o;
        return Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.label, other.label) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.callDirection, (Object)other.callDirection) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals((Object)this.callStatus, (Object)other.callStatus) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.isModerator, other.isModerator) && Objects.equals(this.joinTime, other.joinTime) && Objects.equals(this.leaveTime, other.leaveTime) && Objects.equals(this.durationSeconds, other.durationSeconds) && Objects.equals(this.outboundQueueLength, other.outboundQueueLength) && Objects.equals(this.outboundTimeInQueue, other.outboundTimeInQueue) && Objects.equals((Object)this.jitterBufferSize, (Object)other.jitterBufferSize) && Objects.equals(this.isCoach, other.isCoach) && Objects.equals(this.coachedParticipants, other.coachedParticipants) && Objects.equals((Object)this.participantRegion, (Object)other.participantRegion) && Objects.equals((Object)this.conferenceRegion, (Object)other.conferenceRegion) && Objects.equals((Object)this.callType, (Object)other.callType) && Objects.equals((Object)this.processingState, (Object)other.processingState) && Objects.equals(this.properties, other.properties) && Objects.equals(this.events, other.events) && Objects.equals(this.metrics, other.metrics) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.participantSid, this.label, this.conferenceSid, this.callSid, this.accountSid, this.callDirection, this.from, this.to, this.callStatus, this.countryCode, this.isModerator, this.joinTime, this.leaveTime, this.durationSeconds, this.outboundQueueLength, this.outboundTimeInQueue, this.jitterBufferSize, this.isCoach, this.coachedParticipants, this.participantRegion, this.conferenceRegion, this.callType, this.processingState, this.properties, this.events, this.metrics, this.url});
    }

    public String toString() {
        return "ConferenceParticipant(participantSid=" + this.getParticipantSid() + ", label=" + this.getLabel() + ", conferenceSid=" + this.getConferenceSid() + ", callSid=" + this.getCallSid() + ", accountSid=" + this.getAccountSid() + ", callDirection=" + (Object)((Object)this.getCallDirection()) + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", callStatus=" + (Object)((Object)this.getCallStatus()) + ", countryCode=" + this.getCountryCode() + ", isModerator=" + this.getIsModerator() + ", joinTime=" + this.getJoinTime() + ", leaveTime=" + this.getLeaveTime() + ", durationSeconds=" + this.getDurationSeconds() + ", outboundQueueLength=" + this.getOutboundQueueLength() + ", outboundTimeInQueue=" + this.getOutboundTimeInQueue() + ", jitterBufferSize=" + (Object)((Object)this.getJitterBufferSize()) + ", isCoach=" + this.getIsCoach() + ", coachedParticipants=" + this.getCoachedParticipants() + ", participantRegion=" + (Object)((Object)this.getParticipantRegion()) + ", conferenceRegion=" + (Object)((Object)this.getConferenceRegion()) + ", callType=" + (Object)((Object)this.getCallType()) + ", processingState=" + (Object)((Object)this.getProcessingState()) + ", properties=" + this.getProperties() + ", events=" + this.getEvents() + ", metrics=" + this.getMetrics() + ", url=" + this.getUrl() + ")";
    }

    public static enum Region {
        US1("us1"),
        US2("us2"),
        AU1("au1"),
        BR1("br1"),
        IE1("ie1"),
        JP1("jp1"),
        SG1("sg1"),
        DE1("de1");

        private final String value;

        private Region(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Region forValue(String value) {
            return (Region)Promoter.enumFromString((String)value, (Enum[])Region.values());
        }
    }

    public static enum CallType {
        CARRIER("carrier"),
        CLIENT("client"),
        SIP("sip");

        private final String value;

        private CallType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallType forValue(String value) {
            return (CallType)Promoter.enumFromString((String)value, (Enum[])CallType.values());
        }
    }

    public static enum CallStatus {
        ANSWERED("answered"),
        COMPLETED("completed"),
        BUSY("busy"),
        FAIL("fail"),
        NOANSWER("noanswer"),
        RINGING("ringing"),
        CANCELED("canceled");

        private final String value;

        private CallStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallStatus forValue(String value) {
            return (CallStatus)Promoter.enumFromString((String)value, (Enum[])CallStatus.values());
        }
    }

    public static enum JitterBufferSize {
        LARGE("large"),
        SMALL("small"),
        MEDIUM("medium"),
        OFF("off");

        private final String value;

        private JitterBufferSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static JitterBufferSize forValue(String value) {
            return (JitterBufferSize)Promoter.enumFromString((String)value, (Enum[])JitterBufferSize.values());
        }
    }

    public static enum ProcessingState {
        COMPLETE("complete"),
        IN_PROGRESS("in_progress"),
        TIMEOUT("timeout");

        private final String value;

        private ProcessingState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ProcessingState forValue(String value) {
            return (ProcessingState)Promoter.enumFromString((String)value, (Enum[])ProcessingState.values());
        }
    }

    public static enum CallDirection {
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private final String value;

        private CallDirection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallDirection forValue(String value) {
            return (CallDirection)Promoter.enumFromString((String)value, (Enum[])CallDirection.values());
        }
    }
}

