/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.call.MetricReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Metric
extends Resource {
    private static final long serialVersionUID = 250651350148240L;
    private final String timestamp;
    private final String callSid;
    private final String accountSid;
    private final TwilioEdge edge;
    private final StreamDirection direction;
    private final Map<String, Object> carrierEdge;
    private final Map<String, Object> sipEdge;
    private final Map<String, Object> sdkEdge;
    private final Map<String, Object> clientEdge;

    public static MetricReader reader(String pathCallSid) {
        return new MetricReader(pathCallSid);
    }

    public static Metric fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Metric.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Metric fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Metric.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Metric(@JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="edge") TwilioEdge edge, @JsonProperty(value="direction") StreamDirection direction, @JsonProperty(value="carrier_edge") Map<String, Object> carrierEdge, @JsonProperty(value="sip_edge") Map<String, Object> sipEdge, @JsonProperty(value="sdk_edge") Map<String, Object> sdkEdge, @JsonProperty(value="client_edge") Map<String, Object> clientEdge) {
        this.timestamp = timestamp;
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.edge = edge;
        this.direction = direction;
        this.carrierEdge = carrierEdge;
        this.sipEdge = sipEdge;
        this.sdkEdge = sdkEdge;
        this.clientEdge = clientEdge;
    }

    public final String getTimestamp() {
        return this.timestamp;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final TwilioEdge getEdge() {
        return this.edge;
    }

    public final StreamDirection getDirection() {
        return this.direction;
    }

    public final Map<String, Object> getCarrierEdge() {
        return this.carrierEdge;
    }

    public final Map<String, Object> getSipEdge() {
        return this.sipEdge;
    }

    public final Map<String, Object> getSdkEdge() {
        return this.sdkEdge;
    }

    public final Map<String, Object> getClientEdge() {
        return this.clientEdge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric other = (Metric)o;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.edge, (Object)other.edge) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.carrierEdge, other.carrierEdge) && Objects.equals(this.sipEdge, other.sipEdge) && Objects.equals(this.sdkEdge, other.sdkEdge) && Objects.equals(this.clientEdge, other.clientEdge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.callSid, this.accountSid, this.edge, this.direction, this.carrierEdge, this.sipEdge, this.sdkEdge, this.clientEdge});
    }

    public String toString() {
        return "Metric(timestamp=" + this.getTimestamp() + ", callSid=" + this.getCallSid() + ", accountSid=" + this.getAccountSid() + ", edge=" + (Object)((Object)this.getEdge()) + ", direction=" + (Object)((Object)this.getDirection()) + ", carrierEdge=" + this.getCarrierEdge() + ", sipEdge=" + this.getSipEdge() + ", sdkEdge=" + this.getSdkEdge() + ", clientEdge=" + this.getClientEdge() + ")";
    }

    public static enum TwilioEdge {
        UNKNOWN_EDGE("unknown_edge"),
        CARRIER_EDGE("carrier_edge"),
        SIP_EDGE("sip_edge"),
        SDK_EDGE("sdk_edge"),
        CLIENT_EDGE("client_edge");

        private final String value;

        private TwilioEdge(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TwilioEdge forValue(String value) {
            return (TwilioEdge)Promoter.enumFromString((String)value, (Enum[])TwilioEdge.values());
        }
    }

    public static enum StreamDirection {
        UNKNOWN("unknown"),
        INBOUND("inbound"),
        OUTBOUND("outbound"),
        BOTH("both");

        private final String value;

        private StreamDirection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StreamDirection forValue(String value) {
            return (StreamDirection)Promoter.enumFromString((String)value, (Enum[])StreamDirection.values());
        }
    }
}

