/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.call.Annotation;

public class AnnotationFetcher
extends Fetcher<Annotation> {
    private String pathCallSid;

    public AnnotationFetcher(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    @Override
    public Annotation fetch(TwilioRestClient client) {
        String path = "/v1/Voice/{CallSid}/Annotation";
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Annotation fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Annotation.fromJson(response.getStream(), client.getObjectMapper());
    }
}

