/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.call.AnnotationFetcher;
import com.twilio.rest.insights.v1.call.AnnotationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Annotation
extends Resource {
    private static final long serialVersionUID = 9735005754677L;
    private final String callSid;
    private final String accountSid;
    private final AnsweredBy answeredBy;
    private final ConnectivityIssue connectivityIssue;
    private final List<String> qualityIssues;
    private final Boolean spam;
    private final Integer callScore;
    private final String comment;
    private final String incident;
    private final URI url;

    public static AnnotationFetcher fetcher(String pathCallSid) {
        return new AnnotationFetcher(pathCallSid);
    }

    public static AnnotationUpdater updater(String pathCallSid) {
        return new AnnotationUpdater(pathCallSid);
    }

    public static Annotation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Annotation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Annotation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Annotation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Annotation(@JsonProperty(value="call_sid") String callSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="answered_by") AnsweredBy answeredBy, @JsonProperty(value="connectivity_issue") ConnectivityIssue connectivityIssue, @JsonProperty(value="quality_issues") List<String> qualityIssues, @JsonProperty(value="spam") Boolean spam, @JsonProperty(value="call_score") Integer callScore, @JsonProperty(value="comment") String comment, @JsonProperty(value="incident") String incident, @JsonProperty(value="url") URI url) {
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.answeredBy = answeredBy;
        this.connectivityIssue = connectivityIssue;
        this.qualityIssues = qualityIssues;
        this.spam = spam;
        this.callScore = callScore;
        this.comment = comment;
        this.incident = incident;
        this.url = url;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final AnsweredBy getAnsweredBy() {
        return this.answeredBy;
    }

    public final ConnectivityIssue getConnectivityIssue() {
        return this.connectivityIssue;
    }

    public final List<String> getQualityIssues() {
        return this.qualityIssues;
    }

    public final Boolean getSpam() {
        return this.spam;
    }

    public final Integer getCallScore() {
        return this.callScore;
    }

    public final String getComment() {
        return this.comment;
    }

    public final String getIncident() {
        return this.incident;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation other = (Annotation)o;
        return Objects.equals(this.callSid, other.callSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.answeredBy, (Object)other.answeredBy) && Objects.equals((Object)this.connectivityIssue, (Object)other.connectivityIssue) && Objects.equals(this.qualityIssues, other.qualityIssues) && Objects.equals(this.spam, other.spam) && Objects.equals(this.callScore, other.callScore) && Objects.equals(this.comment, other.comment) && Objects.equals(this.incident, other.incident) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callSid, this.accountSid, this.answeredBy, this.connectivityIssue, this.qualityIssues, this.spam, this.callScore, this.comment, this.incident, this.url});
    }

    public String toString() {
        return "Annotation(callSid=" + this.getCallSid() + ", accountSid=" + this.getAccountSid() + ", answeredBy=" + (Object)((Object)this.getAnsweredBy()) + ", connectivityIssue=" + (Object)((Object)this.getConnectivityIssue()) + ", qualityIssues=" + this.getQualityIssues() + ", spam=" + this.getSpam() + ", callScore=" + this.getCallScore() + ", comment=" + this.getComment() + ", incident=" + this.getIncident() + ", url=" + this.getUrl() + ")";
    }

    public static enum AnsweredBy {
        UNKNOWN_ANSWERED_BY("unknown_answered_by"),
        HUMAN("human"),
        MACHINE("machine");

        private final String value;

        private AnsweredBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AnsweredBy forValue(String value) {
            return (AnsweredBy)Promoter.enumFromString((String)value, (Enum[])AnsweredBy.values());
        }
    }

    public static enum ConnectivityIssue {
        UNKNOWN_CONNECTIVITY_ISSUE("unknown_connectivity_issue"),
        NO_CONNECTIVITY_ISSUE("no_connectivity_issue"),
        INVALID_NUMBER("invalid_number"),
        CALLER_ID("caller_id"),
        DROPPED_CALL("dropped_call"),
        NUMBER_REACHABILITY("number_reachability");

        private final String value;

        private ConnectivityIssue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ConnectivityIssue forValue(String value) {
            return (ConnectivityIssue)Promoter.enumFromString((String)value, (Enum[])ConnectivityIssue.values());
        }
    }
}

