/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.SettingFetcher;
import com.twilio.rest.insights.v1.SettingUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Setting
extends Resource {
    private static final long serialVersionUID = 24698393526973L;
    private final String accountSid;
    private final Boolean advancedFeatures;
    private final Boolean voiceTrace;
    private final URI url;

    public static SettingFetcher fetcher() {
        return new SettingFetcher();
    }

    public static SettingUpdater updater() {
        return new SettingUpdater();
    }

    public static Setting fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Setting.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Setting fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Setting.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Setting(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="advanced_features") Boolean advancedFeatures, @JsonProperty(value="voice_trace") Boolean voiceTrace, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.advancedFeatures = advancedFeatures;
        this.voiceTrace = voiceTrace;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getAdvancedFeatures() {
        return this.advancedFeatures;
    }

    public final Boolean getVoiceTrace() {
        return this.voiceTrace;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting other = (Setting)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.advancedFeatures, other.advancedFeatures) && Objects.equals(this.voiceTrace, other.voiceTrace) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.advancedFeatures, this.voiceTrace, this.url);
    }

    public String toString() {
        return "Setting(accountSid=" + this.getAccountSid() + ", advancedFeatures=" + this.getAdvancedFeatures() + ", voiceTrace=" + this.getVoiceTrace() + ", url=" + this.getUrl() + ")";
    }
}

