/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.pluginconfiguration;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.pluginconfiguration.ConfiguredPlugin;

public class ConfiguredPluginReader
extends Reader<ConfiguredPlugin> {
    private String pathConfigurationSid;
    private String flexMetadata;
    private Integer pageSize;

    public ConfiguredPluginReader(String pathConfigurationSid) {
        this.pathConfigurationSid = pathConfigurationSid;
    }

    public ConfiguredPluginReader setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public ConfiguredPluginReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ConfiguredPlugin> read(TwilioRestClient client) {
        return new ResourceSet<ConfiguredPlugin>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ConfiguredPlugin> firstPage(TwilioRestClient client) {
        String path = "/v1/PluginService/Configurations/{ConfigurationSid}/Plugins";
        path = path.replace("{ConfigurationSid}", this.pathConfigurationSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<ConfiguredPlugin> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConfiguredPlugin read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("plugins", response.getContent(), ConfiguredPlugin.class, client.getObjectMapper());
    }

    @Override
    public Page<ConfiguredPlugin> previousPage(Page<ConfiguredPlugin> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConfiguredPlugin> nextPage(Page<ConfiguredPlugin> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConfiguredPlugin> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

