/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.plugin.PluginVersionsCreator;
import com.twilio.rest.flexapi.v1.plugin.PluginVersionsFetcher;
import com.twilio.rest.flexapi.v1.plugin.PluginVersionsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginVersions
extends Resource {
    private static final long serialVersionUID = 255808209327953L;
    private final String sid;
    private final String pluginSid;
    private final String accountSid;
    private final String version;
    private final URI pluginUrl;
    private final String changelog;
    private final Boolean _private;
    private final Boolean archived;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static PluginVersionsCreator creator(String pathPluginSid, String version, URI pluginUrl) {
        return new PluginVersionsCreator(pathPluginSid, version, pluginUrl);
    }

    public static PluginVersionsFetcher fetcher(String pathPluginSid, String pathSid) {
        return new PluginVersionsFetcher(pathPluginSid, pathSid);
    }

    public static PluginVersionsReader reader(String pathPluginSid) {
        return new PluginVersionsReader(pathPluginSid);
    }

    public static PluginVersions fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginVersions.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PluginVersions fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginVersions.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PluginVersions(@JsonProperty(value="sid") String sid, @JsonProperty(value="plugin_sid") String pluginSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="version") String version, @JsonProperty(value="plugin_url") URI pluginUrl, @JsonProperty(value="changelog") String changelog, @JsonProperty(value="_private") Boolean _private, @JsonProperty(value="archived") Boolean archived, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.pluginSid = pluginSid;
        this.accountSid = accountSid;
        this.version = version;
        this.pluginUrl = pluginUrl;
        this.changelog = changelog;
        this._private = _private;
        this.archived = archived;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getPluginSid() {
        return this.pluginSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getVersion() {
        return this.version;
    }

    public final URI getPluginUrl() {
        return this.pluginUrl;
    }

    public final String getChangelog() {
        return this.changelog;
    }

    public final Boolean get_private() {
        return this._private;
    }

    public final Boolean getArchived() {
        return this.archived;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginVersions other = (PluginVersions)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.pluginSid, other.pluginSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.version, other.version) && Objects.equals(this.pluginUrl, other.pluginUrl) && Objects.equals(this.changelog, other.changelog) && Objects.equals(this._private, other._private) && Objects.equals(this.archived, other.archived) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.pluginSid, this.accountSid, this.version, this.pluginUrl, this.changelog, this._private, this.archived, this.dateCreated, this.url);
    }

    public String toString() {
        return "PluginVersions(sid=" + this.getSid() + ", pluginSid=" + this.getPluginSid() + ", accountSid=" + this.getAccountSid() + ", version=" + this.getVersion() + ", pluginUrl=" + this.getPluginUrl() + ", changelog=" + this.getChangelog() + ", _private=" + this.get_private() + ", archived=" + this.getArchived() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

