/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipant;

public class InteractionChannelParticipantUpdater
extends Updater<InteractionChannelParticipant> {
    private String pathInteractionSid;
    private String pathChannelSid;
    private String pathSid;
    private InteractionChannelParticipant.Status status;

    public InteractionChannelParticipantUpdater(String pathInteractionSid, String pathChannelSid, String pathSid, InteractionChannelParticipant.Status status) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    public InteractionChannelParticipantUpdater setStatus(InteractionChannelParticipant.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public InteractionChannelParticipant update(TwilioRestClient client) {
        String path = "/v1/Interactions/{InteractionSid}/Channels/{ChannelSid}/Participants/{Sid}";
        path = path.replace("{InteractionSid}", this.pathInteractionSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Status}", this.status.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InteractionChannelParticipant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InteractionChannelParticipant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

