/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelInviteCreator;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelInviteReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InteractionChannelInvite
extends Resource {
    private static final long serialVersionUID = 96456011706810L;
    private final String sid;
    private final String interactionSid;
    private final String channelSid;
    private final Map<String, Object> routing;
    private final URI url;

    public static InteractionChannelInviteCreator creator(String pathInteractionSid, String pathChannelSid, Map<String, Object> routing) {
        return new InteractionChannelInviteCreator(pathInteractionSid, pathChannelSid, routing);
    }

    public static InteractionChannelInviteReader reader(String pathInteractionSid, String pathChannelSid) {
        return new InteractionChannelInviteReader(pathInteractionSid, pathChannelSid);
    }

    public static InteractionChannelInvite fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannelInvite.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InteractionChannelInvite fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannelInvite.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InteractionChannelInvite(@JsonProperty(value="sid") String sid, @JsonProperty(value="interaction_sid") String interactionSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="routing") Map<String, Object> routing, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.interactionSid = interactionSid;
        this.channelSid = channelSid;
        this.routing = routing;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getInteractionSid() {
        return this.interactionSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final Map<String, Object> getRouting() {
        return this.routing;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteractionChannelInvite other = (InteractionChannelInvite)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.interactionSid, other.interactionSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.routing, other.routing) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.interactionSid, this.channelSid, this.routing, this.url);
    }

    public String toString() {
        return "InteractionChannelInvite(sid=" + this.getSid() + ", interactionSid=" + this.getInteractionSid() + ", channelSid=" + this.getChannelSid() + ", routing=" + this.getRouting() + ", url=" + this.getUrl() + ")";
    }
}

