/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.WebChannel;

public class WebChannelCreator
extends Creator<WebChannel> {
    private String flexFlowSid;
    private String identity;
    private String customerFriendlyName;
    private String chatFriendlyName;
    private String chatUniqueName;
    private String preEngagementData;

    public WebChannelCreator(String flexFlowSid, String identity, String customerFriendlyName, String chatFriendlyName) {
        this.flexFlowSid = flexFlowSid;
        this.identity = identity;
        this.customerFriendlyName = customerFriendlyName;
        this.chatFriendlyName = chatFriendlyName;
    }

    public WebChannelCreator setFlexFlowSid(String flexFlowSid) {
        this.flexFlowSid = flexFlowSid;
        return this;
    }

    public WebChannelCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public WebChannelCreator setCustomerFriendlyName(String customerFriendlyName) {
        this.customerFriendlyName = customerFriendlyName;
        return this;
    }

    public WebChannelCreator setChatFriendlyName(String chatFriendlyName) {
        this.chatFriendlyName = chatFriendlyName;
        return this;
    }

    public WebChannelCreator setChatUniqueName(String chatUniqueName) {
        this.chatUniqueName = chatUniqueName;
        return this;
    }

    public WebChannelCreator setPreEngagementData(String preEngagementData) {
        this.preEngagementData = preEngagementData;
        return this;
    }

    @Override
    public WebChannel create(TwilioRestClient client) {
        String path = "/v1/WebChannels";
        path = path.replace("{FlexFlowSid}", this.flexFlowSid.toString());
        path = path.replace("{Identity}", this.identity.toString());
        path = path.replace("{CustomerFriendlyName}", this.customerFriendlyName.toString());
        path = path.replace("{ChatFriendlyName}", this.chatFriendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WebChannel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WebChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.flexFlowSid != null) {
            request.addPostParam("FlexFlowSid", this.flexFlowSid);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.customerFriendlyName != null) {
            request.addPostParam("CustomerFriendlyName", this.customerFriendlyName);
        }
        if (this.chatFriendlyName != null) {
            request.addPostParam("ChatFriendlyName", this.chatFriendlyName);
        }
        if (this.chatUniqueName != null) {
            request.addPostParam("ChatUniqueName", this.chatUniqueName);
        }
        if (this.preEngagementData != null) {
            request.addPostParam("PreEngagementData", this.preEngagementData);
        }
    }
}

