/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.PluginRelease;

public class PluginReleaseReader
extends Reader<PluginRelease> {
    private String flexMetadata;
    private Integer pageSize;

    public PluginReleaseReader setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public PluginReleaseReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<PluginRelease> read(TwilioRestClient client) {
        return new ResourceSet<PluginRelease>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PluginRelease> firstPage(TwilioRestClient client) {
        String path = "/v1/PluginService/Releases";
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<PluginRelease> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginRelease read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("releases", response.getContent(), PluginRelease.class, client.getObjectMapper());
    }

    @Override
    public Page<PluginRelease> previousPage(Page<PluginRelease> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PluginRelease> nextPage(Page<PluginRelease> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PluginRelease> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

