/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Interaction;
import java.util.Map;

public class InteractionCreator
extends Creator<Interaction> {
    private Map<String, Object> channel;
    private Map<String, Object> routing;
    private String interactionContextSid;

    public InteractionCreator(Map<String, Object> channel, Map<String, Object> routing) {
        this.channel = channel;
        this.routing = routing;
    }

    public InteractionCreator setChannel(Map<String, Object> channel) {
        this.channel = channel;
        return this;
    }

    public InteractionCreator setRouting(Map<String, Object> routing) {
        this.routing = routing;
        return this;
    }

    public InteractionCreator setInteractionContextSid(String interactionContextSid) {
        this.interactionContextSid = interactionContextSid;
        return this;
    }

    @Override
    public Interaction create(TwilioRestClient client) {
        String path = "/v1/Interactions";
        path = path.replace("{Channel}", this.channel.toString());
        path = path.replace("{Routing}", this.routing.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Interaction creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Interaction.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.channel != null) {
            request.addPostParam("Channel", Converter.mapToJson(this.channel));
        }
        if (this.routing != null) {
            request.addPostParam("Routing", Converter.mapToJson(this.routing));
        }
        if (this.interactionContextSid != null) {
            request.addPostParam("InteractionContextSid", this.interactionContextSid);
        }
    }
}

