/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestionCreator;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestionDeleter;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestionReader;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsQuestionnairesQuestion
extends Resource {
    private static final long serialVersionUID = 10229949486791L;
    private final String accountSid;
    private final String questionSid;
    private final String question;
    private final String description;
    private final Map<String, Object> category;
    private final String answerSetId;
    private final Boolean allowNa;
    private final Integer usage;
    private final Map<String, Object> answerSet;
    private final URI url;

    public static InsightsQuestionnairesQuestionCreator creator(String categorySid, String question, String answerSetId, Boolean allowNa) {
        return new InsightsQuestionnairesQuestionCreator(categorySid, question, answerSetId, allowNa);
    }

    public static InsightsQuestionnairesQuestionDeleter deleter(String pathQuestionSid) {
        return new InsightsQuestionnairesQuestionDeleter(pathQuestionSid);
    }

    public static InsightsQuestionnairesQuestionReader reader() {
        return new InsightsQuestionnairesQuestionReader();
    }

    public static InsightsQuestionnairesQuestionUpdater updater(String pathQuestionSid, Boolean allowNa) {
        return new InsightsQuestionnairesQuestionUpdater(pathQuestionSid, allowNa);
    }

    public static InsightsQuestionnairesQuestion fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnairesQuestion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsQuestionnairesQuestion fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnairesQuestion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsQuestionnairesQuestion(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="question_sid") String questionSid, @JsonProperty(value="question") String question, @JsonProperty(value="description") String description, @JsonProperty(value="category") Map<String, Object> category, @JsonProperty(value="answer_set_id") String answerSetId, @JsonProperty(value="allow_na") Boolean allowNa, @JsonProperty(value="usage") Integer usage, @JsonProperty(value="answer_set") Map<String, Object> answerSet, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.questionSid = questionSid;
        this.question = question;
        this.description = description;
        this.category = category;
        this.answerSetId = answerSetId;
        this.allowNa = allowNa;
        this.usage = usage;
        this.answerSet = answerSet;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getQuestionSid() {
        return this.questionSid;
    }

    public final String getQuestion() {
        return this.question;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, Object> getCategory() {
        return this.category;
    }

    public final String getAnswerSetId() {
        return this.answerSetId;
    }

    public final Boolean getAllowNa() {
        return this.allowNa;
    }

    public final Integer getUsage() {
        return this.usage;
    }

    public final Map<String, Object> getAnswerSet() {
        return this.answerSet;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsQuestionnairesQuestion other = (InsightsQuestionnairesQuestion)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.questionSid, other.questionSid) && Objects.equals(this.question, other.question) && Objects.equals(this.description, other.description) && Objects.equals(this.category, other.category) && Objects.equals(this.answerSetId, other.answerSetId) && Objects.equals(this.allowNa, other.allowNa) && Objects.equals(this.usage, other.usage) && Objects.equals(this.answerSet, other.answerSet) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.questionSid, this.question, this.description, this.category, this.answerSetId, this.allowNa, this.usage, this.answerSet, this.url);
    }

    public String toString() {
        return "InsightsQuestionnairesQuestion(accountSid=" + this.getAccountSid() + ", questionSid=" + this.getQuestionSid() + ", question=" + this.getQuestion() + ", description=" + this.getDescription() + ", category=" + this.getCategory() + ", answerSetId=" + this.getAnswerSetId() + ", allowNa=" + this.getAllowNa() + ", usage=" + this.getUsage() + ", answerSet=" + this.getAnswerSet() + ", url=" + this.getUrl() + ")";
    }
}

