/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsQuestionnaires;
import java.util.List;

public class InsightsQuestionnairesCreator
extends Creator<InsightsQuestionnaires> {
    private String name;
    private String authorization;
    private String description;
    private Boolean active;
    private List<String> questionSids;

    public InsightsQuestionnairesCreator(String name) {
        this.name = name;
    }

    public InsightsQuestionnairesCreator setName(String name) {
        this.name = name;
        return this;
    }

    public InsightsQuestionnairesCreator setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public InsightsQuestionnairesCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    public InsightsQuestionnairesCreator setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public InsightsQuestionnairesCreator setQuestionSids(List<String> questionSids) {
        this.questionSids = questionSids;
        return this;
    }

    public InsightsQuestionnairesCreator setQuestionSids(String questionSids) {
        return this.setQuestionSids(Promoter.listOfOne(questionSids));
    }

    @Override
    public InsightsQuestionnaires create(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Questionnaires";
        path = path.replace("{Name}", this.name.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsQuestionnaires creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InsightsQuestionnaires.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.name != null) {
            request.addPostParam("Name", this.name);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.active != null) {
            request.addPostParam("Active", this.active.toString());
        }
        if (this.questionSids != null) {
            for (String prop : this.questionSids) {
                request.addPostParam("QuestionSids", prop);
            }
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

