/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsConversationsReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsConversations
extends Resource {
    private static final long serialVersionUID = 172863414006149L;
    private final String accountId;
    private final String conversationId;
    private final Integer segmentCount;
    private final List<Map<String, Object>> segments;

    public static InsightsConversationsReader reader() {
        return new InsightsConversationsReader();
    }

    public static InsightsConversations fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsConversations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsConversations fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsConversations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsConversations(@JsonProperty(value="account_id") String accountId, @JsonProperty(value="conversation_id") String conversationId, @JsonProperty(value="segment_count") Integer segmentCount, @JsonProperty(value="segments") List<Map<String, Object>> segments) {
        this.accountId = accountId;
        this.conversationId = conversationId;
        this.segmentCount = segmentCount;
        this.segments = segments;
    }

    public final String getAccountId() {
        return this.accountId;
    }

    public final String getConversationId() {
        return this.conversationId;
    }

    public final Integer getSegmentCount() {
        return this.segmentCount;
    }

    public final List<Map<String, Object>> getSegments() {
        return this.segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsConversations other = (InsightsConversations)o;
        return Objects.equals(this.accountId, other.accountId) && Objects.equals(this.conversationId, other.conversationId) && Objects.equals(this.segmentCount, other.segmentCount) && Objects.equals(this.segments, other.segments);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.conversationId, this.segmentCount, this.segments);
    }

    public String toString() {
        return "InsightsConversations(accountId=" + this.getAccountId() + ", conversationId=" + this.getConversationId() + ", segmentCount=" + this.getSegmentCount() + ", segments=" + this.getSegments() + ")";
    }
}

