/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsAssessmentsCommentCreator;
import com.twilio.rest.flexapi.v1.InsightsAssessmentsCommentReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsAssessmentsComment
extends Resource {
    private static final long serialVersionUID = 175598645429423L;
    private final String accountSid;
    private final String assessmentSid;
    private final Map<String, Object> comment;
    private final BigDecimal offset;
    private final Boolean report;
    private final BigDecimal weight;
    private final String agentId;
    private final String segmentId;
    private final String userName;
    private final String userEmail;
    private final BigDecimal timestamp;
    private final URI url;

    public static InsightsAssessmentsCommentCreator creator(String categoryId, String categoryName, String comment, String segmentId, String agentId, BigDecimal offset) {
        return new InsightsAssessmentsCommentCreator(categoryId, categoryName, comment, segmentId, agentId, offset);
    }

    public static InsightsAssessmentsCommentReader reader() {
        return new InsightsAssessmentsCommentReader();
    }

    public static InsightsAssessmentsComment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsAssessmentsComment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsAssessmentsComment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsAssessmentsComment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsAssessmentsComment(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assessment_sid") String assessmentSid, @JsonProperty(value="comment") Map<String, Object> comment, @JsonProperty(value="offset") BigDecimal offset, @JsonProperty(value="report") Boolean report, @JsonProperty(value="weight") BigDecimal weight, @JsonProperty(value="agent_id") String agentId, @JsonProperty(value="segment_id") String segmentId, @JsonProperty(value="user_name") String userName, @JsonProperty(value="user_email") String userEmail, @JsonProperty(value="timestamp") BigDecimal timestamp, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.assessmentSid = assessmentSid;
        this.comment = comment;
        this.offset = offset;
        this.report = report;
        this.weight = weight;
        this.agentId = agentId;
        this.segmentId = segmentId;
        this.userName = userName;
        this.userEmail = userEmail;
        this.timestamp = timestamp;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssessmentSid() {
        return this.assessmentSid;
    }

    public final Map<String, Object> getComment() {
        return this.comment;
    }

    public final BigDecimal getOffset() {
        return this.offset;
    }

    public final Boolean getReport() {
        return this.report;
    }

    public final BigDecimal getWeight() {
        return this.weight;
    }

    public final String getAgentId() {
        return this.agentId;
    }

    public final String getSegmentId() {
        return this.segmentId;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getUserEmail() {
        return this.userEmail;
    }

    public final BigDecimal getTimestamp() {
        return this.timestamp;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsAssessmentsComment other = (InsightsAssessmentsComment)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assessmentSid, other.assessmentSid) && Objects.equals(this.comment, other.comment) && Objects.equals(this.offset, other.offset) && Objects.equals(this.report, other.report) && Objects.equals(this.weight, other.weight) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.segmentId, other.segmentId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.userEmail, other.userEmail) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assessmentSid, this.comment, this.offset, this.report, this.weight, this.agentId, this.segmentId, this.userName, this.userEmail, this.timestamp, this.url);
    }

    public String toString() {
        return "InsightsAssessmentsComment(accountSid=" + this.getAccountSid() + ", assessmentSid=" + this.getAssessmentSid() + ", comment=" + this.getComment() + ", offset=" + this.getOffset() + ", report=" + this.getReport() + ", weight=" + this.getWeight() + ", agentId=" + this.getAgentId() + ", segmentId=" + this.getSegmentId() + ", userName=" + this.getUserName() + ", userEmail=" + this.getUserEmail() + ", timestamp=" + this.getTimestamp() + ", url=" + this.getUrl() + ")";
    }
}

