/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Assessments;

public class AssessmentsReader
extends Reader<Assessments> {
    private String authorization;
    private String segmentId;
    private Integer pageSize;

    public AssessmentsReader setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public AssessmentsReader setSegmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public AssessmentsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Assessments> read(TwilioRestClient client) {
        return new ResourceSet<Assessments>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Assessments> firstPage(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Assessments";
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Assessments> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Assessments read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("assessments", response.getContent(), Assessments.class, client.getObjectMapper());
    }

    @Override
    public Page<Assessments> previousPage(Page<Assessments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Assessments> nextPage(Page<Assessments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Assessments> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }

    private void addQueryParams(Request request) {
        if (this.segmentId != null) {
            request.addQueryParam("SegmentId", this.segmentId);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

